package org.jsmth.data.domain.support;

/**
 * 描述：
 * author：mason(ma)
 * 日期：16/3/23.
 */
public enum CommonStatus {
    off("禁用", "0"),
    on("启用", "1"),
    delete("逻辑删除", "-1"),
    unknow("其他","");
    ;

    String code="";
    String display="";

    
    
    CommonStatus(String display) {
        this(display,"");
    }

    CommonStatus(String display, String code) {
        this.display = display;
        this.code = code;
    }

    public static CommonStatus[] valuesWithOnOff() {
        CommonStatus[] statuses=new CommonStatus[2];
        statuses[0]=off;
        statuses[1]=on;
        return statuses;
    }
    public static CommonStatus[] valuesWithOnOffUnkonw() {
        CommonStatus[] statuses=new CommonStatus[3];
        statuses[0]=off;
        statuses[1]=on;
        statuses[2]=unknow;
        return statuses;
    }

    public CommonStatus valueOf(int ordinal) {
        if (ordinal >= values().length || ordinal < 0) {
            throw new IllegalArgumentException("IllegalArgument :" + ordinal);
        }
        return values()[ordinal];
    }
    
    public static CommonStatus get(String code) {
        for (CommonStatus e : values()) {
          if(e.code.equals(code)) {
            return e;
          }
        }
        return null;
      }

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getDisplay() {
		return display;
	}

	public void setDisplay(String display) {
		this.display = display;
	}
    
    
    
}
