package org.jsmth.data.domain.support;


import org.apache.commons.lang.StringUtils;
import org.jsmth.data.domain.BaseModel;

import javax.persistence.GenerationType;
import javax.persistence.MappedSuperclass;

/**
 * Created by mason on 15/12/13.
 */
@MappedSuperclass
public class BaseStringModel extends BaseModel<String> {

    @javax.persistence.Id
    @javax.persistence.GeneratedValue(strategy = GenerationType.TABLE)
    String id="";
    public BaseStringModel() {
        setId("");
    }

    public BaseStringModel(String id) {
        super(id);
    }

    public BaseStringModel(BaseModel<String> model) {
        super(model);
    }

    @Override
    public Class<String> getKeyClass() {
        return String.class;
    }

    @Override
    public boolean isNew() {
        return StringUtils.isBlank(getId());
    }

    @Override
    public String getIdentifier() {
        return id;
    }

    @Override
    public void setIdentifier(String id) {
        this.id=id;
    }

    @Override
    public void clear() {
        setId("");
    }
}
