package org.jsmth.data.domain.support;

import org.jsmth.data.domain.BaseModel;

import javax.persistence.MappedSuperclass;

/**
 * Created by mason on 15/12/13.
 */
@MappedSuperclass
public class BaseLongModel extends BaseModel<Long> {
    @javax.persistence.Id
    @javax.persistence.GeneratedValue(strategy = javax.persistence.GenerationType.AUTO)
    long id=0;

    public BaseLongModel() {
        setId(0L);
    }

    public BaseLongModel(Long id) {
        super(id);
    }

    public BaseLongModel(BaseModel<Long> model) {
        super(model);
    }

    @Override
    public Class<Long> getKeyClass() {
        return Long.class;
    }

    @Override
    public boolean isNew() {
        return getId()==0;
    }

    @Override
    public Long getIdentifier() {
        return id;
    }

    @Override
    public void setIdentifier(Long id) {
        this.id=id;
    }

    @Override
    public void clear() {
        setId(0L);
    }
}
