package org.jsmth.data.domain.support;

import org.jsmth.data.domain.BaseModel;

import javax.persistence.MappedSuperclass;

/**
 * Created by mason on 15/12/13.
 */
@MappedSuperclass
public class BaseIntModel extends BaseModel<Integer> {
    @javax.persistence.Id
    @javax.persistence.GeneratedValue(strategy = javax.persistence.GenerationType.AUTO)
    int id;

    public BaseIntModel() {
        setId(0);
    }

    public BaseIntModel(Integer id) {
        super(id);
    }

    public BaseIntModel(BaseModel<Integer> model) {
        super(model);
    }

    @Override
    public Class<Integer> getKeyClass() {
        return Integer.class;
    }

    @Override
    public boolean isNew() {
        return getId()==0;
    }

    @Override
    public Integer getIdentifier() {
        return id;
    }

    @Override
    public void setIdentifier(Integer id) {
        this.id=id;
    }

    @Override
    public void clear() {
        setId(0);
    }
}
