package org.jsmth.data.domain.support;


import org.jsmth.data.domain.BaseModel;
import org.jsmth.util.IdentifierKeyHelper;

import javax.persistence.MappedSuperclass;

/**
 * Created by mason on 15/12/13.
 */
@MappedSuperclass
public class BaseGuidModel extends BaseStringModel {
    public BaseGuidModel() {
        setId(buildKey());
    }

    public BaseGuidModel(String id) {
        super(id);
    }

    public BaseGuidModel(BaseModel<String> model) {
        super(model);
    }

    public String buildKey(){
        return IdentifierKeyHelper.getGuidIdKey();
    }

    @Override
    public void preInsert() {
        setId(buildKey());
        super.preInsert();
    }


}
