package org.jsmth.data.domain.extension.id;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.jsmth.data.domain.extension.AbstractExtension;

import javax.persistence.*;
import java.io.Serializable;

/**
 * Created by mason on 15/12/21.
 */
@Embeddable
@MappedSuperclass
public class IntIdKeyExtension<KEY extends Serializable> extends AbstractExtension {
    @Id
    @GeneratedValue(
            strategy = GenerationType.AUTO
    )
    private KEY id;

    public KEY getId() {
        return id;
    }

    public void setId(KEY id) {
        this.id = id;
    }

    public boolean isNew() {
        return this.getId() != null;
    }

    @Override
    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(id);
        int code = builder.hashCode();
        return code;
    }

    @Override
    public boolean equals(Object obj) {
        IntIdKeyExtension<KEY> instance = (IntIdKeyExtension<KEY>) obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append(id, instance.id);
        boolean equals = builder.isEquals();
        return equals;
    }
}
