package org.jsmth.data.domain.extension;


import org.jsmth.data.domain.Extension;

import javax.persistence.Embeddable;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;

/**
 * 扩展属性类，提供了一个类似Map的接口，将所有属性存放在一个大map中，并使用xstream进行存储
 * 被embedded后，必须被代理的方法包括：getExtension_content,setExtension_content
 * 注意，不支持使用此抽象类嵌入模型中
 *
 * @author mason
 */
@SuppressWarnings({"unchecked"})
@Embeddable
@MappedSuperclass
public abstract class AbstractExtension implements Extension {
    public static final int FORMAT_JSON = 1;
    public static final int FORMAT_XML = 2;

    @Transient
    protected int contentFormat = FORMAT_JSON;

    public AbstractExtension() {
        contentFormat = FORMAT_JSON;
    }

    @Override
    public void preInsert() {
    }
    @Override
    public void preUpdate() {
    }
    @Override
    public void postLoad() {
    }


    public int getContentFormat() {
        return contentFormat;
    }

    public void setContentFormat(int contentFormat) {
        this.contentFormat = contentFormat;
    }
}
