package org.jsmth.data.domain.extend.model;

import org.jsmth.data.domain.extend.BaseExtendModel;
import org.jsmth.data.domain.extend.extension.HiddenExtension;
import org.jsmth.data.domain.extend.extension.TreeExtension;

import javax.persistence.Embedded;
import javax.persistence.MappedSuperclass;
import java.io.Serializable;

/**
 * Created by mason on 2017/8/25.
 */
@MappedSuperclass
public abstract class HiddenTreeModel<KEY extends Serializable> extends BaseExtendModel<KEY> {
    @Embedded
    protected HiddenExtension hiddenExtension;
    @Embedded
    protected TreeExtension treeExtension;

    public HiddenTreeModel() {
        hiddenExtension =new HiddenExtension();
        treeExtension =new TreeExtension();
        registExtension(hiddenExtension);
        registExtension(treeExtension);
    }
}
