package org.jsmth.data.domain.extend.extension;

import org.jsmth.data.domain.IdExtension;
import org.jsmth.data.domain.extension.AbstractExtension;

import javax.persistence.Embeddable;
import javax.persistence.MappedSuperclass;

/**
 * Created by mason on 2017/8/25.
 */
@SuppressWarnings({"unchecked"})
@Embeddable
@MappedSuperclass
public class StringIdExtension extends AbstractExtension   implements IdExtension<String> {
    @javax.persistence.Id
    String id;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getIdentifier() {
        return id;
    }

    @Override
    public void setIdentifier(String id) {
        this.id=id;
    }

    @Override
    public boolean isIdModified() {
        return !"".endsWith(id);
    }

    @Override
    public Class<String> getKeyClass() {
        return String.class;
    }
}
