package org.jsmth.data.domain.extend.extension;

import org.jsmth.data.domain.IdExtension;
import org.jsmth.data.domain.extension.AbstractExtension;

import javax.persistence.Embeddable;
import javax.persistence.MappedSuperclass;

/**
 * Created by mason on 2017/8/25.
 */
@SuppressWarnings({"unchecked"})
@Embeddable
@MappedSuperclass
public class LongIdExtension extends AbstractExtension   implements IdExtension<Long> {
    @javax.persistence.Id
    @javax.persistence.GeneratedValue(strategy = javax.persistence.GenerationType.AUTO)
    long id=0L;

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @Override
    public Long getIdentifier() {
        return id;
    }

    @Override
    public void setIdentifier(Long id) {
        this.id=id;
    }

    @Override
    public boolean isIdModified() {
        return id>0L;
    }

    @Override
    public Class<Long> getKeyClass() {
        return Long.class;
    }
}
