package org.jsmth.data.domain.extend.extension;

import org.jsmth.data.domain.IdExtension;
import org.jsmth.data.domain.extension.AbstractExtension;

import javax.persistence.Embeddable;
import javax.persistence.MappedSuperclass;

/**
 * Created by mason on 2017/8/25.
 */
@SuppressWarnings({"unchecked"})
@Embeddable
@MappedSuperclass
public class IntegerIdExtension extends AbstractExtension  implements IdExtension<Integer> {
    @javax.persistence.Id
    @javax.persistence.GeneratedValue(strategy = javax.persistence.GenerationType.AUTO)
    int id=0;

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    @Override
    public Integer getIdentifier() {
        return id;
    }

    @Override
    public void setIdentifier(Integer id) {
        this.id=id;
    }

    @Override
    public boolean isIdModified() {
        return id!=0;
    }

    @Override
    public Class<Integer> getKeyClass() {
        return Integer.class;
    }
}
