package org.jsmth.data.domain.extend;

import org.jsmth.data.domain.BaseModel;
import org.jsmth.data.domain.Extension;

import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by mason on 2017/8/25.
 */
@MappedSuperclass
public abstract class BaseExtendModel<KEY extends Serializable> extends BaseModel<KEY> {

    @Transient
    List<Extension> extensions=new ArrayList<>();

    public BaseExtendModel() {
        extensions=new ArrayList<>();
    }

    public BaseExtendModel(KEY id) {
        super(id);
        extensions=new ArrayList<>();
    }

    public BaseExtendModel(BaseModel<KEY> model) {
        super(model);
        extensions=new ArrayList<>();
    }

    protected void registExtension(Extension extension){
        extensions.add(extension);
    }

    @Override
    public void postLoad() {
        super.postLoad();
        for (Extension extension : extensions) {
            extension.postLoad();
        }
    }

    @Override
    public void preInsert() {
        super.preInsert();
        for (Extension extension : extensions) {
            extension.preInsert();
        }
    }

    @Override
    public void preUpdate() {
        super.preUpdate();
        for (Extension extension : extensions) {
            extension.preUpdate();
        }
    }

}
