package org.jsmth.data.domain.ext.time;

import org.jsmth.data.domain.BaseModel;
import org.jsmth.util.IdentifierKeyHelper;

import javax.persistence.MappedSuperclass;
import java.io.Serializable;
import java.util.Date;

/**
 * Created by mason on 2017/8/25.
 */
@MappedSuperclass
public abstract class CreateUpdateModel<KEY extends Serializable> extends BaseModel<KEY> {
    long createtime=0;
    long updatetime=0;

    @Override
    public void preInsert() {
        if(createtime==0) {
            createtime = new Date().getTime();
        }
        super.preInsert();
    }
    @Override
    public void preUpdate() {
        updatetime = new Date().getTime();
        super.preUpdate();
    }

    public long getCreatetime() {
        return createtime;
    }

    public void setCreatetime(long createtime) {
        this.createtime = createtime;
    }

    public long getUpdatetime() {
        return updatetime;
    }

    public void setUpdatetime(long updatetime) {
        this.updatetime = updatetime;
    }
}

