package org.jsmth.data.domain.ext.support;


import org.apache.commons.lang.StringUtils;
import org.jsmth.data.domain.ext.BothRelationModel;
import org.jsmth.data.domain.ext.CreateUpdateTimeModel;

import javax.persistence.GenerationType;
import javax.persistence.MappedSuperclass;
import java.io.Serializable;

/**
 * Created by mason on 15/12/13.
 */
@MappedSuperclass
public class BothRelationStringModel<ONEKEY extends Serializable,TWOKEY extends Serializable>
        extends BothRelationModel<String,ONEKEY,TWOKEY> {

    @javax.persistence.Id
    @javax.persistence.GeneratedValue(strategy = GenerationType.TABLE)
    String id="";
    public BothRelationStringModel() {
        setId("");
    }

    @Override
    public Class<String> getKeyClass() {
        return String.class;
    }

    @Override
    public boolean isNew() {
        return StringUtils.isBlank(getId());
    }

    @Override
    public String getIdentifier() {
        return id;
    }

    @Override
    public void setIdentifier(String id) {
        this.id=id;
    }

    @Override
    public void clear() {
        setId("");
    }

    @Override
    public String getId() {
        return id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }
}
