package org.jsmth.data.domain.ext;

import org.jsmth.data.domain.BaseModel;

import javax.persistence.MappedSuperclass;
import java.io.Serializable;
import java.util.Date;

/**
 * Created by mason on 15/12/14.
 */
@MappedSuperclass
public abstract class CreateUpdateTimeModel<KEY extends Serializable> extends UpdateTimeModel<KEY>{
    long createtime=0L;

    @Override
    public void preInsert() {
        if(createtime==0) {
            createtime = new Date().getTime();
        }
        super.preInsert();
    }


    public long getCreatetime() {
        return createtime;
    }

    public void setCreatetime(long createtime) {
        this.createtime = createtime;
    }
}
