package org.jsmth.data.domain.ext;

import org.jsmth.data.domain.BaseModel;

import javax.persistence.MappedSuperclass;
import java.io.Serializable;
import java.util.Date;

/**
 * 描述：
 * author：mason(ma)
 * 日期：16/12/2.
 */
@MappedSuperclass
public abstract class CorgCIdCreateUpdateTimeModel<KEY extends Serializable> extends BaseModel<KEY> {
    int corg=0;
    KEY cid;
    long updatetime=0L;
    long createtime=0L;

    @Override
    public void preInsert() {
        if(createtime==0) {
            createtime = new Date().getTime();
        }
        super.preInsert();
    }

    @Override
    public void preUpdate() {
        if(updatetime==0) {
            updatetime = new Date().getTime();
        }
        super.preUpdate();
    }


    public int getCorg() {
        return corg;
    }

    public void setCorg(int corg) {
        this.corg = corg;
    }

    public KEY getCid() {
        return cid;
    }

    public void setCid(KEY cid) {
        this.cid = cid;
    }

    public long getUpdatetime() {
        return updatetime;
    }

    public void setUpdatetime(long updatetime) {
        this.updatetime = updatetime;
    }

    public long getCreatetime() {
        return createtime;
    }

    public void setCreatetime(long createtime) {
        this.createtime = createtime;
    }

    @Override
    public KEY getId() {
        return super.getId();
    }

    @Override
    public void setId(KEY id) {
        super.setId(id);
    }
}
