package org.jsmth.data.domain;

import org.jsmth.domain.Identifier;
import org.springframework.data.domain.Persistable;

import javax.persistence.*;
import java.io.Serializable;

/**
 * 最基本的数据持久化模型
 * 子类可以定义任意的主键
 */
@MappedSuperclass
public abstract class ProtoModel<KEY extends Serializable> implements Persistable<KEY>, Identifier<KEY> {
    public ProtoModel() {
    }

    @PostLoad
    public void postLoad() {
    }

    @PrePersist
    public void preInsert() {
    }

    @PreUpdate
    public void preUpdate() {
    }

    @PreRemove
    public void preRemove() {
    }


    @PostPersist
    public void postInsert() {
    }

    @PostUpdate
    public void postUpdate() {
    }

    @PostRemove
    public void postRemove() {
    }

    public abstract void clear();


    @Override
    public KEY getId() {
        return getIdentifier();
    }

    public void setId(KEY id) {
        setIdentifier(id);
    }

    @Override
    public boolean isNew() {
        return false;
    }

    @Override
    public KEY getIdentifier() {
        return getId();
    }

    @Override
    public void setIdentifier(KEY id) {

    }

    @Override
    public boolean isIdModified() {
        return !isNew();
    }
}
