package org.jsmth.data.domain;

import org.jsmth.data.domain.extension.FullMapExtension;

import javax.persistence.Embedded;
import javax.persistence.MappedSuperclass;
import java.io.Serializable;

/**
 * 在基本的基础上扩展的数据模型，增加了一个字段存储多种数据的结构
 */
@MappedSuperclass
public abstract class ExtModel<KEY extends Serializable> extends BaseModel<KEY> {

    @Embedded
    protected FullMapExtension extension;

    public ExtModel() {
        createDefaultExtension();
    }

    protected void createDefaultExtension(){
        if(extension ==null){
            extension =new FullMapExtension();
        }
    }

    public ExtModel(KEY id) {
        super(id);
        createDefaultExtension();
    }

    public ExtModel(ExtModel<KEY> model) {
        super(model);
        createDefaultExtension();
    }

    @Override
    public void postLoad() {
        extension.postLoad();
        super.postLoad();
    }

    @Override
    public void preInsert() {
        extension.preInsert();
        super.preInsert();
    }

    @Override
    public void preUpdate() {
        extension.preUpdate();
        super.preUpdate();
    }

    public FullMapExtension getExtension() {
        return extension;
    }

    public void setExtension(FullMapExtension extension) {
        this.extension = extension;
    }
}
