package org.jsmth.data.domain;

import org.springframework.data.jpa.domain.AbstractPersistable;

import javax.persistence.*;
import java.io.Serializable;

/**
 * 基本的数据模型，主键定位id
 */
@MappedSuperclass
public abstract class BaseModel<KEY extends Serializable> extends ProtoModel<KEY> implements Model<KEY> {

    public BaseModel() {
    }
    public BaseModel(KEY id) {
        setId(id);
    }
    public BaseModel(BaseModel<KEY> model) {
        setId(model.getId());
    }



    public abstract Class<KEY> getKeyClass();

}
