package org.jsmth.data.dialect;

import org.jsmth.data.sql.Types;

import javax.transaction.NotSupportedException;

/**
 * Created by mason on 15/12/16.
 */
public class SQLiteDialect extends GenericDialect {

    @Override
    protected void init() {
        super.init();
        registerColumnType(Types.BIT, "integer");
        registerColumnType(Types.TINYINT, "tinyint");
        registerColumnType(Types.SMALLINT, "smallint");
        registerColumnType(Types.INTEGER, "integer");
        registerColumnType(Types.BIGINT, "bigint");
        registerColumnType(Types.FLOAT, "float");
        registerColumnType(Types.REAL, "real");
        registerColumnType(Types.DOUBLE, "double");
        registerColumnType(Types.NUMERIC, "numeric");
        registerColumnType(Types.DECIMAL, "decimal");
        registerColumnType(Types.CHAR, "char");
        registerColumnType(Types.VARCHAR, "varchar");
        registerColumnType(Types.LONGVARCHAR, "longvarchar");
        registerColumnType(Types.DATE, "date");
        registerColumnType(Types.TIME, "time");
        registerColumnType(Types.TIMESTAMP, "timestamp");
        registerColumnType(Types.BINARY, "blob");
        registerColumnType(Types.VARBINARY, "blob");
        registerColumnType(Types.LONGVARBINARY, "blob");
        // registerColumnType(Types.NULL, "null");
        registerColumnType(Types.BLOB, "blob");
        registerColumnType(Types.CLOB, "clob");
        registerColumnType(Types.BOOLEAN, "integer");
    }

    @Override
    public String getIdentitySelectString() {
        return "select last_insert_rowid()";
    }

    @Override
    public boolean supportIfExistsBeforTableName() {
        return false;
    }

    @Override
    public boolean supportIfExistsAfterTableName() {
        return false;
    }

    @Override
    public String getDropTableString(String tableName) {
        StringBuilder sql=new StringBuilder();
        sql.append("drop table ");
        sql.append(tableName);
        return sql.toString();
    }

    @Override
    public String getIfExistBeforTableString(String tableName) {
        StringBuilder sql=new StringBuilder();
        return sql.toString();
    }

    @Override
    public String getIfExistAfterTableString(String tableName) {
        return super.getIfExistAfterTableString(tableName);
    }

    @Override
    public String getDropIndexString(String tableName,String indexName) {
        StringBuilder sql=new StringBuilder();
        sql.append("drop index ");
        sql.append(indexName);
        sql.append(" on ");
        sql.append(tableName);
        return sql.toString();
    }

    @Override
    public boolean supportLimit() {
        return true;
    }

    @Override
    public boolean supportLimitOffset() {
        return true;
    }

    @Override
    public String getLimitString(String sqlString, int offset, int limit) {
        StringBuilder sql=new StringBuilder();
        sql.append(sqlString);
        sql.append(" limit ");
        sql.append(offset);
        sql.append(",");
        sql.append(limit);
        return sql.toString();
    }

    @Override
    public String addInsertAfterGetKeyString(String sql) {
        return sql+";select last_insert_rowid();";
    }

    @Override
    public String qualifyNamePrefix() {
        return "`";
    }

    @Override
    public String qualifyNameSuffix() {
        return "`";
    }

    @Override
    public String qualifyColumnPrefix() {
        return "`";
    }

    @Override
    public String qualifyColumnSuffix() {
        return "`";
    }

    @Override
    public String getDriverClassName() {
        return "org.sqlite.JDBC";
    }

    @Override
    public String buildConnectUrl(String ip, int port, String database) {
        StringBuilder url=new StringBuilder();
        url.append("jdbc:sqlite:");
        url.append(database);
        return url.toString();
    }
}
