package org.jsmth.data.dialect;

import javax.transaction.NotSupportedException;
import java.sql.Types;

/**
 * Created by mason on 15/12/16.
 */
public class PostgreSQLDialect extends GenericDialect {
    @Override
    protected void init() {
        super.init();
        registerColumnType( Types.BIT, "bool" );
        registerColumnType( Types.BIGINT, "int8" );
        registerColumnType( Types.SMALLINT, "int2" );
        registerColumnType( Types.TINYINT, "int2" );
        registerColumnType( Types.INTEGER, "int4" );
        registerColumnType( Types.CHAR, "char(1)" );
        registerColumnType( Types.VARCHAR, "varchar($l)" );
        registerColumnType( Types.FLOAT, "float4" );
        registerColumnType( Types.DOUBLE, "float8" );
        registerColumnType( Types.DATE, "date" );
        registerColumnType( Types.TIME, "time" );
        registerColumnType( Types.TIMESTAMP, "timestamp" );
        registerColumnType( Types.VARBINARY, "bytea" );
        registerColumnType( Types.BINARY, "bytea" );
        registerColumnType( Types.LONGVARCHAR, "text" );
        registerColumnType( Types.LONGVARBINARY, "bytea" );
        registerColumnType( Types.CLOB, "text" );
        registerColumnType( Types.BLOB, "oid" );
        registerColumnType( Types.NUMERIC, "numeric($p, $s)" );
        registerColumnType( Types.OTHER, "uuid" );
    }


    @Override
    public String getLimitString(String sql, int offset, int limit) {
        StringBuilder builder=new StringBuilder();
        builder.append(sql);
        builder.append(" limit ");
        builder.append(offset);
        builder.append(" offset ");
        builder.append(limit);
        return builder.toString();
    }
    @Override
    public String getDriverClassName() {
        return "org.postgresql.Driver";
    }

    @Override
    public String buildConnectUrl(String ip, int port, String database) {
        StringBuilder url=new StringBuilder();
        url.append("jdbc:postgresql://");
        url.append(ip);
        if(port==0){
            port=5432;
        }
        url.append(":");
        url.append(port);
        url.append("/");
        url.append(database);
        return url.toString();
    }
}
