package org.jsmth.data.dialect;

import javax.transaction.NotSupportedException;
import java.sql.Types;

/**
 * Created by mason on 15/12/16.
 */
public class OracleDialect extends GenericDialect {

    @Override
    protected void init() {
        super.init();
        registerColumnType( Types.BIT, "number(1,0)" );
        registerColumnType( Types.BIGINT, "number(19,0)" );
        registerColumnType( Types.SMALLINT, "number(5,0)" );
        registerColumnType( Types.TINYINT, "number(3,0)" );
        registerColumnType( Types.INTEGER, "number(10,0)" );
        registerColumnType( Types.CHAR, "char(1 char)" );
        registerColumnType( Types.VARCHAR, 4000, "varchar2($l char)" );
        registerColumnType( Types.VARCHAR, "long" );
        registerColumnType( Types.FLOAT, "float" );
        registerColumnType( Types.DOUBLE, "double precision" );
        registerColumnType( Types.DATE, "date" );
        registerColumnType( Types.TIME, "date" );
        registerColumnType( Types.TIMESTAMP, "timestamp" );
        registerColumnType( Types.VARBINARY, 2000, "raw($l)" );
        registerColumnType( Types.VARBINARY, "long raw" );
        registerColumnType( Types.NUMERIC, "number($p,$s)" );
        registerColumnType( Types.DECIMAL, "number($p,$s)" );
        registerColumnType( Types.BLOB, "blob" );
        registerColumnType( Types.CLOB, "clob" );
    }

    @Override
    public String addInsertAfterGetKeyString(String sql) {
        return sql+";SELECT CUSTOM_SQL.NEXTVAL AS ID FROM DUAL;";
    }

    @Override
    public String getLimitString(String sql, int offset, int limit) {
        StringBuilder builder=new StringBuilder();
        int beginRow=(offset-1)*limit;
        int endRow=offset*limit;
        builder.append("SELECT * FROM \n" +
                " ( SELECT tablepagequery.*, ROWNUM RN  FROM \n" +
                " (");
        builder.append(sql);
        builder.append(") tablepagequery  WHERE ROWNUM <= ");
        builder.append(endRow);
        builder.append(") WHERE RN >= ？");
        builder.append(beginRow);
        return builder.toString();
    }
    @Override
    public String getDriverClassName() {
        return "oracle.jdbc.driver.OracleDriver";
    }

    @Override
    public String buildConnectUrl(String ip, int port, String database) {
        StringBuilder url=new StringBuilder();
        url.append("jdbc:oracle:thin:@");
        url.append(ip);
        if(port==0){
            port=1521;
        }
        url.append(":");
        url.append(port);
        url.append(":");
        url.append(database);
        return url.toString();
    }
}
