package org.jsmth.data.dialect;

import javax.transaction.NotSupportedException;
import java.sql.Types;

/**
 * Created by mason on 15/12/16.
 */
public class MySQLDialect extends GenericDialect {

    @Override
    protected void init() {
        super.init();
        registerColumnType( Types.BIT, "bit" );
        registerColumnType( Types.BIGINT, "bigint" );
        registerColumnType( Types.SMALLINT, "smallint" );
        registerColumnType( Types.TINYINT, "tinyint" );
        registerColumnType( Types.INTEGER, "integer" );
        registerColumnType( Types.CHAR, "char(1)" );
        registerColumnType( Types.FLOAT, "float" );
        registerColumnType( Types.DOUBLE, "double precision" );
        registerColumnType( Types.BOOLEAN, "bit" ); // HHH-6935
        registerColumnType( Types.DATE, "date" );
        registerColumnType( Types.TIME, "time" );
        registerColumnType( Types.TIMESTAMP, "datetime" );
        registerColumnType( Types.VARBINARY, "longblob" );
        registerColumnType( Types.VARBINARY, 16777215, "mediumblob" );
        registerColumnType( Types.VARBINARY, 65535, "blob" );
        registerColumnType( Types.VARBINARY, 255, "tinyblob" );
        registerColumnType( Types.BINARY, "binary($l)" );
        registerColumnType( Types.LONGVARBINARY, "longblob" );
        registerColumnType( Types.LONGVARBINARY, 16777215, "mediumblob" );
        registerColumnType( Types.NUMERIC, "decimal($p,$s)" );
        registerColumnType( Types.BLOB, "longblob" );
//		registerColumnType( Types.BLOB, 16777215, "mediumblob" );
//		registerColumnType( Types.BLOB, 65535, "blob" );
        registerColumnType( Types.CLOB, "longtext" );
//		registerColumnType( Types.CLOB, 16777215, "mediumtext" );
//		registerColumnType( Types.CLOB, 65535, "text" );

        registerColumnType( Types.VARCHAR, "longtext" );
//		registerColumnType( Types.VARCHAR, 16777215, "mediumtext" );
//		registerColumnType( Types.VARCHAR, 65535, "text" );
        registerColumnType( Types.VARCHAR, 255, "varchar($l)" );
        registerColumnType( Types.LONGVARCHAR, "longtext" );
    }

    @Override
    public boolean supportIfExistsBeforTableName() {
        return false;
    }

    @Override
    public boolean supportIfExistsAfterTableName() {
        return false;
    }

    @Override
    public String getDropTableString(String tableName)  {
        StringBuilder sql=new StringBuilder();
        sql.append("drop table ");
        sql.append(tableName);
        return sql.toString();
    }

    @Override
    public String getIfExistBeforTableString(String tableName)  {
        StringBuilder sql=new StringBuilder();
        return sql.toString();
    }

    @Override
    public String getIfExistAfterTableString(String tableName)  {
        return super.getIfExistAfterTableString(tableName);
    }

    @Override
    public String getDropIndexString(String tableName,String indexName)  {
        StringBuilder sql=new StringBuilder();
        sql.append("drop index ");
        sql.append(indexName);
        sql.append(" on ");
        sql.append(tableName);
        return sql.toString();
    }

    @Override
    public boolean supportLimit() {
        return true;
    }

    @Override
    public boolean supportLimitOffset() {
        return true;
    }

    @Override
    public String getLimitString(String sqlString, int offset, int limit)  {
        StringBuilder sql=new StringBuilder();
        sql.append(sqlString);
        sql.append(" limit ");
        sql.append(offset);
        sql.append(",");
        sql.append(limit);
        return sql.toString();
    }

    @Override
    public String addInsertAfterGetKeyString(String sql) {
        return sql+";SELECT LAST_INSERT_ID();";
    }

    @Override
    public String qualifyNamePrefix() {
        return "`";
    }

    @Override
    public String qualifyNameSuffix() {
        return "`";
    }

    @Override
    public String qualifyColumnPrefix() {
        return "`";
    }

    @Override
    public String qualifyColumnSuffix() {
        return "`";
    }


    @Override
    public String getDriverClassName() {
        return "com.mysql.jdbc.Driver";
    }

    @Override
    public String buildConnectUrl(String ip, int port, String database) {
        StringBuilder url=new StringBuilder();
        url.append("jdbc:mysql://");
        url.append(ip);
        if(port==0){
            port=3306;
        }
        url.append(":");
        url.append(port);
        url.append("/");
        url.append(database);
        url.append("?useUnicode=true&amp;characterEncoding=utf-8&amp;autoReconnect=true&amp;autoReconnectForPools=true");
        return url.toString();
    }

    public String getColumnValuePreTag(Class<?> valueClass){
        return "'";
    }
    public String getColumnValuePostTag(Class<?> valueClass){
        return "'";
    }

}
