package org.jsmth.data.dialect;

import javax.transaction.NotSupportedException;
import java.sql.Types;

/**
 * Created by mason on 15/12/16.
 */
public class HSQLDialect extends GenericDialect {

    @Override
    protected void init() {
        super.init();
        registerColumnType(Types.BIGINT, "bigint");
        registerColumnType(Types.BINARY, "binary($l)");
        registerColumnType(Types.BIT, "bit");
        registerColumnType(Types.BOOLEAN, "boolean");
        registerColumnType(Types.CHAR, "char($l)");
        registerColumnType(Types.DATE, "date");

        registerColumnType(Types.DECIMAL, "decimal($p,$s)");
        registerColumnType(Types.DOUBLE, "double");
        registerColumnType(Types.FLOAT, "float");
        registerColumnType(Types.INTEGER, "integer");
        registerColumnType(Types.LONGVARBINARY, "longvarbinary");
        registerColumnType(Types.LONGVARCHAR, "longvarchar");
        registerColumnType(Types.SMALLINT, "smallint");
        registerColumnType(Types.TINYINT, "tinyint");
        registerColumnType(Types.TIME, "time");
        registerColumnType(Types.TIMESTAMP, "timestamp");
        registerColumnType(Types.VARCHAR, "varchar($l)");
        registerColumnType(Types.VARBINARY, "varbinary($l)");

        registerColumnType(Types.NUMERIC, "numeric($p,$s)");
        registerColumnType(Types.BLOB, "blob($l)");
        registerColumnType(Types.CLOB, "clob($l)");
    }

    @Override
    public boolean supportIfExistsBeforTableName() {
        return false;
    }

    @Override
    public boolean supportIfExistsAfterTableName() {
        return false;
    }

    @Override
    public String getDropTableString(String tableName)  {
        StringBuilder sql = new StringBuilder();
        sql.append("drop table ");
        sql.append(tableName);
        return sql.toString();
    }

    @Override
    public String getIfExistBeforTableString(String tableName)  {
        StringBuilder sql = new StringBuilder();
        return sql.toString();
    }

    @Override
    public String getIfExistAfterTableString(String tableName)  {
        return super.getIfExistAfterTableString(tableName);
    }

    @Override
    public String getDropIndexString(String tableName, String indexName)  {
        StringBuilder sql = new StringBuilder();
        sql.append("drop index ");
        sql.append(indexName);
        sql.append(" on ");
        sql.append(tableName);
        return sql.toString();
    }

    @Override
    public boolean supportLimit() {
        return true;
    }

    @Override
    public boolean supportLimitOffset() {
        return true;
    }

    @Override
    public String getLimitString(String sqlString, int offset, int limit)  {
        StringBuilder sql = new StringBuilder();
        sql.append(sqlString);
        sql.append(" limit ");
        sql.append(offset);
        sql.append(",");
        sql.append(limit);
        return sql.toString();
    }
    @Override
    public String addInsertAfterGetKeyString(String sql) {
        return sql+";CALL IDENTITY() ;";
    }
    @Override
    public String qualifyNamePrefix() {
        return "`";
    }

    @Override
    public String qualifyNameSuffix() {
        return "`";
    }

    @Override
    public String qualifyColumnPrefix() {
        return "`";
    }

    @Override
    public String qualifyColumnSuffix() {
        return "`";
    }

    @Override
    public String getDriverClassName() {
        return "org.hsqldb.jdbcDriver";
    }

    @Override
    public String buildConnectUrl(String ip, int port, String database) {
        StringBuilder url=new StringBuilder();
        url.append("jdbc:hsqldb:mem:.");


        //jdbc:hsqldb:mem:.
        //jdbc:hsqldb:file:E:/hsqldb/data/mydb
        //jdbc:hsqldb:hsql://localhost:PORT/DB_NAME);
        return url.toString();
    }
}
