package org.jsmth.data.dialect;

import org.jsmth.data.sql.TypeNames;
import org.jsmth.data.sql.Types;
import org.jsmth.exception.SmthException;

import javax.transaction.NotSupportedException;

/**
 * Created by mason on 15/12/16.
 */
public abstract class GenericDialect implements Dialect {

    protected TypeNames typeNames;

    public GenericDialect() {
        typeNames=new TypeNames();
        init();
    }

    protected void init(){

    }

    @Override
    public String addInsertAfterGetKeyString(String sql) {
        return null;
    }

    @Override
    public Types getSchemaType(Class columnType) {
        return null;
    }

    @Override
    public Class getColumnType(Types schemaType) {
        return null;
    }

    protected void registerColumnType(int schemaType,String name){
        typeNames.put(schemaType,name);
    }
    protected void registerColumnType(int code, long capacity, String name) {
        typeNames.put( code, capacity, name );
    }

    public String getIdentitySelectString() {
        return "select last_insert_rowid()";
    }

    @Override
    public boolean supportIfExistsBeforTableName() {
        return false;
    }

    @Override
    public boolean supportIfExistsAfterTableName() {
        return false;
    }

    @Override
    public String getDropTableString(String tableName)  {
        StringBuilder sql=new StringBuilder();
        sql.append("drop table ");
        sql.append(tableName);
        return sql.toString();
    }

    @Override
    public String getIfExistBeforTableString(String tableName)  {
        throw new SmthException("not support is method");
    }

    @Override
    public String getIfExistAfterTableString(String tableName)  {
        throw new SmthException("not support is method");
    }

    @Override
    public String getDropIndexString(String tableName,String indexName)  {
        StringBuilder sql=new StringBuilder();
        sql.append("drop index ");
        sql.append(indexName);
        sql.append(" on ");
        sql.append(tableName);
        return sql.toString();
    }

    @Override
    public boolean supportLimit() {
        return false;
    }

    @Override
    public boolean supportLimitOffset() {
        return false;
    }

    @Override
    public String getLimitString(String sql, int offset, int limit)  {
        throw new SmthException("not support is method");
    }

    @Override
    public String qualifyNamePrefix() {
        return "";
    }

    @Override
    public String qualifyNameSuffix() {
        return "";
    }

    @Override
    public String qualifyColumnPrefix() {
        return "";
    }

    @Override
    public String qualifyColumnSuffix() {
        return "";
    }

    public String getColumnValuePreTag(Class<?> valueClass){
        return qualifyColumnPrefix();
    }
    public String getColumnValuePostTag(Class<?> valueClass){
        return qualifyColumnSuffix();
    }

    @Override
    public String getDriverClassName() {
        return "";
    }

    @Override
    public String buildConnectUrl(String ip, int port,String database) {
        return "";
    }

    @Override
    public String buildConnectUrl(String ip, String database) {
        return buildConnectUrl(ip,0,database);
    }

    @Override
    public String sqlTruncateTable(String tableName) {
        return "truncate table "+tableName;
    }
}
