package org.jsmth.data.dialect;

/**
 * Created by mason on 16/1/5.
 */
public enum DialectType {
    Db2("Db2Dialect",new Db2Dialect()),
    HSQL("HSQLDialect",new HSQLDialect()),
    MySQL("MySQLDialect",new MySQLDialect()),
    Oracle("OracleDialect",new OracleDialect()),
    PostgreSQL("PostgreSQLDialect",new PostgreSQLDialect()),
    SQLite("SQLiteDialect",new SQLiteDialect()),
    SQLServer("SQLServerDialect",new SQLServerDialect()),
    Other("MySQLDialect",new MySQLDialect()),
;

    String id;
    Dialect dialect;

    DialectType(String id, Dialect dialect) {
        this.id = id;
        this.dialect = dialect;
    }

    public static DialectType getById(String id) {
        DialectType[] values = DialectType.values();
        for (DialectType value : values) {
            if (value.getId().equals(id)) {
                return value;
            }
        }
        return null;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Dialect getDialect() {
        return dialect;
    }

    public void setDialect(Dialect dialect) {
        this.dialect = dialect;
    }
}
