package org.jsmth.data.dialect;

import org.apache.commons.dbcp.BasicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Created by mason on 15/12/16.
 */
public class DialectFactory {
    protected static Logger logger = LoggerFactory.getLogger(DialectFactory.class);

    public static Dialect getDialect(String dialect) {
        if ("Db2Dialect".equals(dialect)) {
            return new Db2Dialect();
        }
        if ("HSQLDialect".equals(dialect)) {
            return new HSQLDialect();
        }
        if ("MySQLDialect".equals(dialect)) {
            return new MySQLDialect();
        }
        if ("OracleDialect".equals(dialect)) {
            return new OracleDialect();
        }
        if ("PostgreSQLDialect".equals(dialect)) {
            return new PostgreSQLDialect();
        }
        if ("SQLiteDialect".equals(dialect)) {
            return new SQLiteDialect();
        }
        if ("SQLServerDialect".equals(dialect)) {
            return new SQLServerDialect();
        }
        if (dialect == null)
            dialect = "";
        throw new IllegalArgumentException("Dialect " + dialect + " not support.");
    }

    public static Dialect getDialect(BasicDataSource ds) {
        String driverClassName = ds.getDriverClassName();
        if ("oracle.jdbc.driver.OracleDriver".equals(driverClassName)) {
            return new OracleDialect();
        }
        if ("com.microsoft.jdbc.sqlserver.SQLServerDriver".equals(driverClassName)) {
            return new SQLServerDialect();
        }
        if ("com.microsoft.sqlserver.jdbc.SQLServerDriver".equals(driverClassName)) {
            return new SQLServerDialect();
        }
        if ("com.ibm.db2.jdbc.app.DB2Driver".equals(driverClassName)) {
            return new Db2Dialect();
        }
        if ("com.mysql.jdbc.Driver".equals(driverClassName)) {
            return new MySQLDialect();
        }
        if ("org.hsqldb.jdbcDriver".equals(driverClassName)) {
            return new HSQLDialect();
        }
        if ("org.postgresql.Driver".equals(driverClassName)) {
            return new PostgreSQLDialect();
        }
        if ("org.sqlite.JDBC".equals(driverClassName)) {
            return new SQLiteDialect();
        }
        if ("com.p6spy.engine.spy.P6SpyDriver".equals(driverClassName)) {
            return new P6SpyDialect();
        }


        throw new IllegalArgumentException("datasource " + ds.toString() + " not support.");
    }

    public static <T extends org.hibernate.dialect.Dialect> T getHibernateDialect(Dialect dialect) {
        return getHibernateDialect(dialect.getClass().getSimpleName());
    }

    /**
     * 根据本地方言，获得Hibernate中的方言对象
     *
     * @param dialectName ff
     * @param <T> ff
     * @return 返回信息
     */
    public static <T extends org.hibernate.dialect.Dialect> T getHibernateDialect(String dialectName) {
        try {
            logger.debug("Hibernate dialect is org.hibernate.dialect." + dialectName);
            return (T) Class.forName("org.hibernate.dialect." + dialectName).newInstance();
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}
