package org.jsmth.data.dialect;

import org.jsmth.data.sql.EntityQuery;
import org.jsmth.data.sql.Types;

import javax.transaction.NotSupportedException;

/**
 * Created by mason on 15/12/16.
 */
public interface Dialect {
    boolean supportIfExistsBeforTableName();
    boolean supportIfExistsAfterTableName();
    String getDropTableString(String tableName) ;
    String getIfExistBeforTableString(String tableName) ;
    String getIfExistAfterTableString(String tableName) ;

    String addInsertAfterGetKeyString(String sql);

    String getDropIndexString(String tableName, String indexName) ;

    boolean supportLimit();
    boolean supportLimitOffset();
    String getLimitString(String sql, int offset, int limit) ;

    String qualifyNamePrefix();
    String qualifyNameSuffix();

    String qualifyColumnPrefix();
    String qualifyColumnSuffix();

    String getColumnValuePreTag(Class<?> valueClass);
    String getColumnValuePostTag(Class<?> valueClass);

    Types getSchemaType(Class columnType);
    Class getColumnType(Types schemaType);

    String getIdentitySelectString();

    String getDriverClassName();
    String buildConnectUrl(String ip, int port, String database);
    String buildConnectUrl(String ip, String database);
    String sqlTruncateTable(String tableName);


}
