package org.jsmth.data.dialect;

import javax.transaction.NotSupportedException;
import java.sql.Types;

/**
 * Created by mason on 15/12/16.
 */
public class Db2Dialect extends GenericDialect {


    @Override
    protected void init() {
        super.init();
        registerColumnType(Types.BINARY, "binary($l)");
        registerColumnType( Types.BIT, "tinyint" );
        registerColumnType( Types.BIGINT, "numeric(19,0)" );
        registerColumnType( Types.SMALLINT, "smallint" );
        registerColumnType( Types.TINYINT, "smallint" );
        registerColumnType( Types.INTEGER, "int" );
        registerColumnType( Types.CHAR, "char(1)" );
        registerColumnType( Types.VARCHAR, "varchar($l)" );
        registerColumnType( Types.FLOAT, "float" );
        registerColumnType( Types.DOUBLE, "double precision" );
        registerColumnType( Types.DATE, "datetime" );
        registerColumnType( Types.TIME, "datetime" );
        registerColumnType( Types.TIMESTAMP, "datetime" );
        registerColumnType( Types.VARBINARY, "varbinary($l)" );
        registerColumnType( Types.NUMERIC, "numeric($p,$s)" );
        registerColumnType( Types.BLOB, "image" );
        registerColumnType( Types.CLOB, "text" );

        registerColumnType( Types.VARBINARY, "image" );
        registerColumnType( Types.VARBINARY, 8000, "varbinary($l)" );
        registerColumnType( Types.LONGVARBINARY, "image" );
        registerColumnType( Types.LONGVARCHAR, "text" );
        registerColumnType(Types.BOOLEAN, "bit");
    }

    @Override
    public boolean supportIfExistsBeforTableName() {
        return true;
    }

    @Override
    public boolean supportIfExistsAfterTableName() {
        return true;
    }


    @Override
    public String getIfExistBeforTableString(String tableName)  {
        StringBuilder sql=new StringBuilder();
        return sql.toString();
    }

    @Override
    public String getIfExistAfterTableString(String tableName)  {
        return super.getIfExistAfterTableString(tableName);
    }

    @Override
    public boolean supportLimit() {
        return true;
    }

    @Override
    public boolean supportLimitOffset() {
        return true;
    }

    @Override
    public String getLimitString(String sqlString, int offset, int limit)  {
        StringBuilder sql=new StringBuilder();
        sql.append(sqlString);
        sql.append(" limit ");
        sql.append(offset);
        sql.append(",");
        sql.append(limit);
        return sql.toString();
    }

    @Override
    public String addInsertAfterGetKeyString(String sql) {
        return sql+"; VALUES IDENTITY_VAL_LOCAL() ;";
    }

    @Override
    public String qualifyNamePrefix() {
        return "[";
    }

    @Override
    public String qualifyNameSuffix() {
        return "]";
    }

    @Override
    public String qualifyColumnPrefix() {
        return "[";
    }

    @Override
    public String qualifyColumnSuffix() {
        return "]";
    }

    @Override
    public String getDriverClassName() {
        return "com.ibm.db2.jcc.DB2Driver";
    }

    @Override
    public String buildConnectUrl(String ip, int port, String database) {
        StringBuilder url=new StringBuilder();
        url.append("jdbc:db2://");
        url.append(ip);
        if(port==0){
            port=50000;
        }
        url.append(":");
        url.append(port);
        url.append("/");
        url.append(database);
        return url.toString();
    }
}
