package org.jsmth.data.dao;


import org.jsmth.data.jdbc.JdbcDao;
import org.jsmth.data.jdbc.Query;
import org.jsmth.data.sql.item.OrderType;
import org.jsmth.jorm.jdbc.EntityEventCallback;
import org.jsmth.domain.Identifier;
import org.jsmth.page.Page;

import javax.persistence.MappedSuperclass;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/**
 * Created by mason on 15/12/26.
 */
@MappedSuperclass
public interface IEntityDao<KEY extends Serializable, MODEL extends Identifier<KEY>> extends IBaseEntityDao<MODEL>, EntityEventCallback {


    MODEL save(MODEL model);


    MODEL insert(MODEL model);


    int update(MODEL model);


    int updateByIdAndWhere(MODEL model, String where, Object... params);

    int updateByWhere(MODEL model, String where, Object... params);

    int delete(MODEL model);


    int deleteAll();

    int deleteById(KEY id);

    //<editor-fold desc="rebuildSchema">
    void rebuildSchema(Class... entityClass);
    <K extends Serializable> void setBeginKey(K beginKey,boolean isdelete,Class... entityClasss);
    //</editor-fold>

    //<editor-fold desc="getId">
    MODEL getById(KEY id);

    //     MODEL getById(boolean checkNull,KEY id)  {
//        return SmthCheckExceptionUtil.checkIsNull(getJdbcDao().getById(checkNull, entityClass, id), checkNull);
//    }
//     MODEL getById(boolean checkNull,String errorMessage,String errorCode,KEY id)  {
//        return SmthCheckExceptionUtil.checkIsNull(getById(checkNull,id), checkNull, errorMessage, errorCode);
//    }
//     MODEL getById(boolean checkNull,SmthExceptionDictHandler exceptionEnum,KEY id)  {
//        return SmthCheckExceptionUtil.checkIsNull(getById(checkNull,id), checkNull, exceptionEnum);
//    }
    MODEL getByIdOrNew(KEY id);

    MODEL getByIdOrNew(KEY id, boolean setid);

    MODEL getByIdOrNew(KEY id, boolean setid, boolean insert);

    MODEL getOrCreateById(KEY id);
    //</editor-fold>

    //<editor-fold desc="get">
    MODEL getSortFirstOne(String fieldName, OrderType orderType);

    MODEL getFirstModel();

    MODEL getLastModel();

    //</editor-fold>
    //<editor-fold desc="find ids">
    //</editor-fold>
    //<editor-fold desc="find ids">
    List<MODEL> findByIds(List<? extends KEY> ids);

    List<MODEL> findByIdsOrNew(List<? extends KEY> ids);

    //</editor-fold>


    //<editor-fold desc="insert">

//     void insertAll(Collection<MODEL> entities)  {
//        getJdbcDao().insertAll(entities);
//    }
    //</editor-fold>

    //<editor-fold desc="update">

//     int updateFields(MODEL entity, String... fieldNames)  {
//        return getJdbcDao().updateFeilds(entity, fieldNames);
//    }
//
//     int updateFeilds(boolean exclude, String[] fieldNames, Object[] values, String where, Object... params)  {
//        return getJdbcDao().updateFeilds(entityClass, exclude, fieldNames, values, where, params);
//    }
//
//     int updateFeilds(String[] fieldNames, Object[] values, String where, Object... params)  {
//        return getJdbcDao().updateFeilds(entityClass, false, fieldNames, values, where, params);
//    }
//
//     int updateFeild(String fieldName, Object value, String where, Object... params)  {
//        Object[] values = new Object[1];
//        values[0] = value;
//        return updateFeilds(new String[]{fieldName}, values, where, params);
//    }
//
//
//     int updateAllFeilds(boolean exclude, String[] fieldNames, Object[] values)  {
//        return updateFeilds(exclude, fieldNames, values, "1=1");
//    }
//
//     int updateAllFeilds(String[] fieldNames, Object[] values)  {
//        return updateFeilds(false, fieldNames, values, "1=1");
//    }
//
//     int updateAllFeild(String fieldName, Object value)  {
//        return updateFeild(fieldName, value, "1=1");
//    }


//     int updateFeild(Class<MODEL> entityClass, String fieldName, String where, Object... params)  {
//        MODEL entity = null;
//        try {
//            entity = entityClass.newInstance();
//        } catch (Exception e) {
//            throw new AppletIllegalArgumentException(e.getMessage());
//        }
//        try {
//            BeanUtils.setProperty(entity, fieldName, value);
//        } catch (Exception e) {
//            throw new AppletIllegalArgumentException(e.getMessage());
//        }
//        return getJdbcDao().updateFeilds(entity, false, new String[]{fieldName}, where, params);
//    }

//     int updateAll(Collection<MODEL> entities)  {
//        return getJdbcDao().updateAll(entities);
//    }
//
//     int updateFeildsAll(Collection<MODEL> entities, String... fieldNames)  {
//        return getJdbcDao().updateFeildsAll(entities, fieldNames);
//    }
    //</editor-fold>

    //<editor-fold desc="delete">


    int deleteAll(Collection<MODEL> entities);
//
//     int deleteById(Serializable id) {
//        return getJdbcDao().deleteById(entityClass, id);
//    }

    /**
     * 根据条件删除一组实体
     *
     * @param where ff
     * @param params ff
     * @return 返回信息
     */
    int deleteModels(String where, Object... params);

    int deleteByIds(Collection<? extends KEY> ids);
    //</editor-fold>

    //<editor-fold desc="findids">
    List<KEY> findIds(Class<KEY> kClass, String where, Object... params);
    List<KEY> findIds(Class<KEY> kClass, Query query);
    //</editor-fold>


    //<editor-fold desc="getmodel">


    MODEL getModel(String where, Object... params);
    MODEL getModel(Query query);

    //</editor-fold>

    //<editor-fold desc="getcolumn">
    <C> List<C> findColumns(Class<C> columnClass, String fieldName, String where, Object... params);
    <C> List<C> findColumns(Class<C> columnClass, String fieldName, Query query);


    //</editor-fold>

    <K> Page<K> pageColumns(Class<K> kClass, int pageNumber, int pageSize, boolean totalRecord, String select, Query query);

    //<editor-fold desc="count">
    int count(String where, Object... params);
    int count( Query query);
    //</editor-fold>

    JdbcDao getJdbcDao();
    void setJdbcDao(JdbcDao jdbcDao);

    Class<KEY> getKeyClass();


    List<MODEL> findModels(String where, Object... params);
    List<MODEL> findModels( Query query);

//    <C> List<C> findColumns(Class<C> cClass, String columnName, String where, Object... params);

    List<Map<String, Object>> findMaps(Query query);
    List<Map<String,Object>> findMaps(String where, Object... params);

    List<Map<String,Object>> findMaps( String select, String where, Object... params);
    List<Map<String,Object>> findMaps( String select, Query query);

//    <K> List<K> findIds(Class<K> kClass, String where, Object... params);

//    <MODEL> MODEL getModel(String where, Object... params);

    <C> C getColumn(Class<C> cClass, String columnName, String where, Object... params);
    <C> C getColumn(Class<C> cClass, String columnName, Query query);

    Map<String, Object> getMap( Query query);
    Map<String,Object> getMap( String where, Object... params);

    Map<String,Object> getMap(String select, String where, Object... params);
    Map<String,Object> getMap(String select,  Query query);

    KEY getId( String where, Object... params);
}
