package org.jsmth.data.dao;

import org.jsmth.data.jdbc.ITableJdbcDao;
import org.jsmth.data.jdbc.Query;
import org.jsmth.data.sql.EntityQuery;
import org.jsmth.data.sql.wrap.WhereWrap;
import org.jsmth.domain.Identifier;
import org.jsmth.jorm.jdbc.EntityEventCallback;
import org.jsmth.page.Page;

import javax.persistence.MappedSuperclass;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * Created by mason on 15/12/26.
 */
@MappedSuperclass
public interface IBaseEntityDao<MODEL> extends EntityEventCallback  , Serializable {


    List<MODEL> findAll();

    Page<MODEL> findAll(int pageNumber, int pageSize);

    Page<MODEL> findPageModels(WhereWrap wrap, int pageNumber, int pageSize, boolean totalRecord);

    Page<MODEL> findPageModels(EntityQuery query);

    Page<MODEL> pageModels(int pageNumber, int pageSize, boolean totalRecord, String where, Object... params);
    Page<MODEL> pageModels(int pageNumber, int pageSize, boolean totalRecord, Query query);

    List<MODEL> findModels(WhereWrap wrap);

    List<MODEL> findModels(EntityQuery query);

    <K> List<K> findColumns(Class<K> kClass, WhereWrap wrap);

    <K> List<K> findColumns(Class<K> kClass, EntityQuery query);

    <K> List<K> findColumns(Class<K> kClass, String columnName,String where,Object...params);


    <K> Page<K> pageIds(Class<K> kClass,int pageNumber, int pageSize, boolean totalRecord, String where, Object...params);

    <K> Page<K> pageColumns(Class<K> kClass, int pageNumber, int pageSize, boolean totalRecord, String select, String where, Object...params);

    <K> Page<K> pageColumns(Class<K> kClass, WhereWrap wrap, int pageNumber, int pageSize, boolean totalRecord);

    <K> Page<K> pageColumns(Class<K> kClass, EntityQuery query);


    MODEL getModel(WhereWrap where);

    MODEL getModel(EntityQuery query);

    /**
     * 根据条件，查询得到一组model
     *
     * @param where ff
     * @param params ff
     * @return 返回信息
     */
    List<MODEL> findModels(String where, Object... params);


    <T, E> List<E> groupColumn(Class<E> columnClass, String fieldName, String where, Object... params);

    <T> List<T> findColumn(Class<T> columnClass, String fieldName, String where, Object... params);

    <T> Page<T> pageFindColumn(Class<T> columnClass, String fieldName, String where, int pageNumber, int pageSize, Object... params);
    <T> Page<T> pageFindColumn(Class<T> columnClass, String fieldName,int pageNumber, int pageSize, Query query);
    void rebuildSchema(Class... entityClass);


    List<MODEL> query(WhereWrap where);


    MODEL queryForObject(WhereWrap where);


    List<Map<String, Object>> queryForList(WhereWrap where);

    EntityEventCallback getEntityEventCallback();

    void setEntityEventCallback(EntityEventCallback entityEventCallback);
    Class<MODEL> getEntityClass();
    Class getKeyClass();
    ITableJdbcDao getTableJdbcDao();

    List<Map<String,Object>> queryForListMap(String sql);
}
