package org.jsmth.data.dao;

import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.dbcp.BasicDataSource;
import org.jsmth.data.dialect.Dialect;
import org.jsmth.data.dialect.DialectFactory;
import org.jsmth.data.jdbc.Query;
import org.jsmth.domain.Identifier;
import org.jsmth.data.jdbc.JdbcDao;
import org.jsmth.data.schema.ObjectTableMeta;
import org.jsmth.data.sql.item.OrderType;
import org.jsmth.data.sql.wrap.WhereWrap;
import org.jsmth.jorm.jdbc.*;
import org.jsmth.page.CommonPage;
import org.jsmth.page.Page;
import org.jsmth.util.BeanUtils;
import org.jsmth.util.IdentifierKeyHelper;
import org.jsmth.util.ObjectUtils;

import javax.persistence.MappedSuperclass;
import java.io.Serializable;
import java.util.*;

/**
 * Created by mason on 15/12/26.
 */
@MappedSuperclass
public class EntityDao<KEY extends Serializable, MODEL extends Identifier<KEY>> extends BaseEntityDao<MODEL> implements IEntityDao<KEY, MODEL> {


    //JdbcDao jdbcDao;
    public EntityDao(Class<MODEL> entityClass) {
        super(entityClass);
    }

    @Override
    public JdbcDao getJdbcDao() {
        return (JdbcDao) tableJdbcDao;
    }

    @Override
    public void setJdbcDao(JdbcDao jdbcDao) {
        this.tableJdbcDao = jdbcDao;
    }

    @Override
    public MODEL save(MODEL model) {
        return getJdbcDao().save(model);
    }

    @Override
    public MODEL insert(MODEL model) {
        return getJdbcDao().insert(model);
    }

    @Override
    public int update(MODEL model) {
        return getJdbcDao().updateModelById(model);
    }

    @Override
    public int updateByIdAndWhere(MODEL model, String where, Object... params) {
        return getJdbcDao().updateModelByIdAndWhere(model, where, params);
    }

    @Override
    public int updateByWhere(MODEL model, String where, Object... params) {
        return getJdbcDao().updateModelByWhere(model, where, params);
    }

    @Override
    public int delete(MODEL model) {
        return getJdbcDao().delete(model);
    }

    @Override
    public int deleteAll() {
        return getJdbcDao().deleteAll(entityClass);
    }

    @Override
    public int deleteById(KEY id) {
        return getJdbcDao().deleteById(entityClass, id);
    }

    //<editor-fold desc="rebuildSchema">
    @SuppressWarnings({"unchecked"})
    @Override
    public void rebuildSchema(Class... entityClass) {
        //和init方法中一样，重建表也是先重建从库，并指定主库不创建索引
        for (Class clazz : entityClass) {
            getJdbcDao().doDropTable(clazz);
            getJdbcDao().doCreateTable(clazz);
            getJdbcDao().doCreateIndexs(clazz);
        }
    }

    @Override
    public <K extends Serializable> void setBeginKey(K beginKey, boolean isdelete, Class... entityClasss) {
        for (Class clazz : entityClasss) {
            try {
                Identifier<K> instance = (Identifier<K>) clazz.newInstance();
                instance.setIdentifier(beginKey);
                instance = getJdbcDao().insert(instance);
                if (isdelete) {
                    getJdbcDao().delete(instance);
                }
            } catch (InstantiationException e) {
                e.printStackTrace();
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }
    //</editor-fold>

    //<editor-fold desc="getId">
    @Override
    public MODEL getById(KEY id) {
        return getJdbcDao().getById(entityClass, id);
    }

    //    public MODEL getById(boolean checkNull,KEY id)  {
//        return SmthCheckExceptionUtil.checkIsNull(getJdbcDao().getById(checkNull, entityClass, id), checkNull);
//    }
//    public MODEL getById(boolean checkNull,String errorMessage,String errorCode,KEY id)  {
//        return SmthCheckExceptionUtil.checkIsNull(getById(checkNull,id), checkNull, errorMessage, errorCode);
//    }
//    public MODEL getById(boolean checkNull,SmthExceptionDictHandler exceptionEnum,KEY id)  {
//        return SmthCheckExceptionUtil.checkIsNull(getById(checkNull,id), checkNull, exceptionEnum);
//    }
    @Override
    public MODEL getByIdOrNew(KEY id) {
        return getByIdOrNew(id, true);
    }

    @Override
    public MODEL getByIdOrNew(KEY id, boolean setid) {
        return getByIdOrNew(id, setid, true);
    }

    @Override
    public MODEL getByIdOrNew(KEY id, boolean setid, boolean insert) {
        MODEL model = getJdbcDao().getById(entityClass, id);
        if (model == null) {
            try {
                model = this.entityClass.newInstance();
            } catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            if (setid)
                model.setIdentifier(id);
            if (insert) {
                model = insert(model);
            }
        }
        return model;
    }

    @Override
    public MODEL getOrCreateById(KEY id) {
        return getJdbcDao().getOrCreateById(entityClass, id);
    }
    //</editor-fold>

    //<editor-fold desc="get">
    public MODEL getSortFirstOne(String fieldName, OrderType orderType) {
//        EntityQuery query=new EntityQuery(entityClass);
//            query.o(fieldName,orderType);
        String where = "1=1 order by " + fieldName;
        if (orderType == OrderType.DESC) {
            where += " desc";
        }
        where += " limit 1";
        return getModel(where);
    }

    @Override
    public MODEL getFirstModel() {
        return getSortFirstOne("id", OrderType.ASC);
    }

    @Override
    public MODEL getLastModel() {
        return getSortFirstOne("id", OrderType.DESC);
    }

    //</editor-fold>
    //<editor-fold desc="find ids">
    //</editor-fold>
    //<editor-fold desc="find ids">
    @Override
    public List<MODEL> findByIds(List<? extends KEY> ids) {
        if (ids == null || ids.size() == 0) {
            return new ArrayList<>();
        }
        ObjectTableMeta<MODEL> table = ObjectTableMeta.getTable(entityClass);
        return getJdbcDao().queryByColumns(entityClass, table.getIdColumn().getFieldName(), ids.toArray());
    }

    @Override
    public List<MODEL> findByIdsOrNew(List<? extends KEY> ids) {
        if (ids == null || ids.size() == 0) {
            return new ArrayList<>();
        }
        List<MODEL> dbModels = findByIds(ids);
        List<MODEL> models = new LinkedList<MODEL>(dbModels);
        List<KEY> noKeys = new LinkedList<KEY>(ids);
        for (MODEL model : dbModels) {
            noKeys.remove(model.getIdentifier());
        }
        for (KEY noKey : noKeys) {
            models.add(getByIdOrNew(noKey));
        }
        return models;
    }

    //</editor-fold>


    //<editor-fold desc="insert">

//    public void insertAll(Collection<MODEL> entities)  {
//        getJdbcDao().insertAll(entities);
//    }
    //</editor-fold>

    //<editor-fold desc="update">

//    public int updateFields(MODEL entity, String... fieldNames)  {
//        return getJdbcDao().updateFeilds(entity, fieldNames);
//    }
//
//    public int updateFeilds(boolean exclude, String[] fieldNames, Object[] values, String where, Object... params)  {
//        return getJdbcDao().updateFeilds(entityClass, exclude, fieldNames, values, where, params);
//    }
//
//    public int updateFeilds(String[] fieldNames, Object[] values, String where, Object... params)  {
//        return getJdbcDao().updateFeilds(entityClass, false, fieldNames, values, where, params);
//    }
//
//    public int updateFeild(String fieldName, Object value, String where, Object... params)  {
//        Object[] values = new Object[1];
//        values[0] = value;
//        return updateFeilds(new String[]{fieldName}, values, where, params);
//    }
//
//
//    public int updateAllFeilds(boolean exclude, String[] fieldNames, Object[] values)  {
//        return updateFeilds(exclude, fieldNames, values, "1=1");
//    }
//
//    public int updateAllFeilds(String[] fieldNames, Object[] values)  {
//        return updateFeilds(false, fieldNames, values, "1=1");
//    }
//
//    public int updateAllFeild(String fieldName, Object value)  {
//        return updateFeild(fieldName, value, "1=1");
//    }


//    public int updateFeild(Class<MODEL> entityClass, String fieldName, String where, Object... params)  {
//        MODEL entity = null;
//        try {
//            entity = entityClass.newInstance();
//        } catch (Exception e) {
//            throw new AppletIllegalArgumentException(e.getMessage());
//        }
//        try {
//            BeanUtils.setProperty(entity, fieldName, value);
//        } catch (Exception e) {
//            throw new AppletIllegalArgumentException(e.getMessage());
//        }
//        return getJdbcDao().updateFeilds(entity, false, new String[]{fieldName}, where, params);
//    }

//    public int updateAll(Collection<MODEL> entities)  {
//        return getJdbcDao().updateAll(entities);
//    }
//
//    public int updateFeildsAll(Collection<MODEL> entities, String... fieldNames)  {
//        return getJdbcDao().updateFeildsAll(entities, fieldNames);
//    }
    //</editor-fold>

    //<editor-fold desc="delete">


    public int deleteAll(Collection<MODEL> entities) {
        ObjectTableMeta<MODEL> table = ObjectTableMeta.getTable(entityClass);
        List<KEY> ids = ObjectUtils.getFields(entities, table.getIdColumn().getFieldName());
        return deleteByIds(ids);
    }
//
//    public int deleteById(Serializable id) {
//        return getJdbcDao().deleteById(entityClass, id);
//    }

    /**
     * 根据条件删除一组实体
     *
     * @param where ff
     * @param params ff
     * @return 返回信息
     */
    public int deleteModels(String where, Object... params) {
        String sql = getTableJdbcDao().buildDeleteSql(entityClass, where.toString());
        return getJdbcDao().update(sql, params);
    }

    public int deleteByIds(Collection<? extends KEY> ids) {
        StringBuilder where = new StringBuilder();
        for (KEY id : ids) {
            if (where.length() > 0) {
                where.append(",");
            }
            where.append("?");
        }
        where.insert(0, "id in (");
        where.append(")");
        return deleteModels(where.toString(), ids.toArray());
    }
    //</editor-fold>

    //<editor-fold desc="findids">
    public List<KEY> findIds(Class<KEY> kClass, String where, Object... params) {
        ObjectTableMeta<MODEL> table = ObjectTableMeta.getTable(entityClass);
        return getJdbcDao().queryColumn(entityClass, kClass, table.getIdColumn().getFieldName(), where,params);
    }

    @Override
    public List<KEY> findIds(Class<KEY> kClass, Query query) {
        Table table = Table.getTable(entityClass);
        List sqlParas = new LinkedList<>();
        String sql = query.buildWhere(table.getTableName(), sqlParas);
        return findIds(kClass, sql, sqlParas.toArray());
    }

    //</editor-fold>


    public String getTableName() {
        return Table.getTable(entityClass).getTableName();
    }

    public List<MODEL> getFieldsByCollection(Collection beans, String fieldName) {
        return IdentifierKeyHelper.getFields(beans, fieldName);
    }

    public <T> void copyProperties(T orig, T dest) throws Exception {
        PropertyUtils.copyProperties(orig, dest);
    }


    //<editor-fold desc="getmodel">


    public MODEL getModel(String where, Object... params) {
        List<MODEL> models = findModels(where, params);
        if (models.size() == 0) {
            return null;
        }
        return models.get(0);
    }

    @Override
    public MODEL getModel(Query query) {
        Table table = Table.getTable(entityClass);
        List sqlParas = new LinkedList<>();
        String sql = query.buildWhere(table.getTableName(), sqlParas);
        return getModel(sql, sqlParas.toArray());
    }

    //</editor-fold>

    @Override
    public Page<MODEL> pageModels(int pageNumber, int pageSize, boolean totalRecord, String where, Object... params) {
        String sql = getJdbcDao().buildQuerySql(entityClass, "count(*)", where);
        Integer count = getJdbcDao().queryForObject(Integer.class, sql, params);
        sql = getJdbcDao().buildQuerySql(entityClass, "*", where);
        if (pageNumber < 1) {
            pageNumber = 1;
        }
        CommonPage<MODEL> page = new CommonPage<>();
        page.setPageNumber(pageNumber);
        page.setPageSize(pageSize);
        page.setTotalItemsCount(count);
        Dialect dialect = DialectFactory.getDialect((BasicDataSource) getJdbcDao().getDataSource());
        sql = dialect.getLimitString(sql, (pageNumber - 1) * pageSize, pageSize);
        page.setItems(getTableJdbcDao().queryForEntityList(entityClass, sql, params));
        return page;
    }


    //<editor-fold desc="getcolumn">
    @Override
    public <C> List<C> findColumns(Class<C> columnClass, String fieldName, String where, Object... params) {
        WhereWrap whereWrap = new WhereWrap();
        whereWrap.placeholderW(where, params);
        return getJdbcDao().queryColumn(entityClass, columnClass, fieldName, whereWrap);
    }

    @Override
    public <C> List<C> findColumns(Class<C> columnClass, String fieldName, org.jsmth.data.jdbc.Query query) {
        Table table = Table.getTable(entityClass);
        List sqlParas = new LinkedList<>();
        String sql = query.buildWhere(table.getTableName(), sqlParas);
        return findColumns(columnClass, fieldName, sql, sqlParas.toArray());
    }

    @Override
    public int count(Query query) {
        Table table = Table.getTable(entityClass);
        List sqlParas = new LinkedList<>();
        String sql = query.buildWhere(table.getTableName(), sqlParas);
        return count(sql, sqlParas.toArray());
    }

    @Override
    public <K> Page<K> pageColumns(Class<K> kClass, int pageNumber, int pageSize, boolean totalRecord, String select, String where, Object... params) {
        String sql = getJdbcDao().buildQuerySql(entityClass, "count(*)", where);
        Integer count = getJdbcDao().queryForObject(Integer.class, sql, params);
        sql = getJdbcDao().buildQuerySql(entityClass, select, where);
        if (pageNumber < 1) {
            pageNumber = 1;
        }
        CommonPage<K> page = new CommonPage<>();
        page.setPageNumber(pageNumber);
        page.setPageSize(pageSize);
        page.setTotalItemsCount(count);

        Dialect dialect = DialectFactory.getDialect((BasicDataSource) getJdbcDao().getDataSource());
        sql = dialect.getLimitString(sql, (pageNumber - 1) * pageSize, pageSize);
        page.setItems(getTableJdbcDao().queryForList(kClass, sql, params));
        return page;
    }

    @Override
    public <K> Page<K> pageColumns(Class<K> kClass, int pageNumber, int pageSize, boolean totalRecord, String select, org.jsmth.data.jdbc.Query query) {
        Table table = Table.getTable(entityClass);
        List sqlParas = new LinkedList<>();
        String sql = query.buildWhere(table.getTableName(), sqlParas);
        return pageColumns(kClass, pageNumber, pageSize, totalRecord, select, sql, sqlParas.toArray());
    }
    //</editor-fold>

    //<editor-fold desc="count">
    @Override
    public int count(String where, Object... params) {
        WhereWrap whereWrap = new WhereWrap();
        whereWrap.placeholderW(where, params);
        return getJdbcDao().queryForInt(entityClass, whereWrap);
    }

    //</editor-fold>
    @Override
    public Class<KEY> getKeyClass() {
        MODEL instance = BeanUtils.createInstance(entityClass);
        return instance.getKeyClass();
    }

    @Override
    public List<MODEL> findModels(Query query) {
        Table table = Table.getTable(entityClass);
        List sqlParas = new LinkedList<>();
        String sql = query.buildWhere(table.getTableName(), sqlParas);
        return findModels(sql, sqlParas.toArray());
    }


    //<editor-fold desc="新的接口，未证实">
//    @Override
//    public List<MODEL> findModels(String where, Object... params) {
//        WhereWrap whereWrap=new WhereWrap();
//        whereWrap.placeholderW(where,params);
//        return findModels(whereWrap);
//    }
    @Override
    public List<Map<String, Object>> findMaps(Query query) {
        Table table = Table.getTable(entityClass);
        List sqlParas = new LinkedList<>();
        String sql = query.buildWhere(table.getTableName(), sqlParas);
        return findMaps(sql, sqlParas.toArray());
    }

    @Override
    public List<Map<String, Object>> findMaps(String where, Object... params) {
        return getJdbcDao().findMaps(getEntityClass(), where, params);
    }

    @Override
    public List<Map<String, Object>> findMaps(String select, String where, Object... params) {
        return getJdbcDao().findMaps(getEntityClass(), select, where, params);
    }

    @Override
    public List<Map<String, Object>> findMaps(String select, Query query) {
        Table table = Table.getTable(entityClass);
        List sqlParas = new LinkedList<>();
        String sql = query.buildWhere(table.getTableName(), sqlParas);
        return findMaps(sql, sqlParas.toArray());
    }

    @Override
    public <C> C getColumn(Class<C> cClass, String columnName, String where, Object... params) {
        List<C> columns = findColumns(cClass, columnName, where, params);
        if (columns == null || columns.size() == 0) {
            return null;
        }
        return columns.get(0);
    }

    @Override
    public <C> C getColumn(Class<C> cClass, String columnName, Query query) {
        Table table = Table.getTable(entityClass);
        List sqlParas = new LinkedList<>();
        String sql = query.buildWhere(table.getTableName(), sqlParas);
        return getColumn(cClass, columnName, sql, sqlParas.toArray());
    }

    @Override
    public Map<String, Object> getMap(Query query) {
        Table table = Table.getTable(entityClass);
        List sqlParas = new LinkedList<>();
        String sql = query.buildWhere(table.getTableName(), sqlParas);
        return getMap(sql, sqlParas.toArray());
    }

    @Override
    public Map<String, Object> getMap(String where, Object... params) {
        return getJdbcDao().getMap(getEntityClass(), where, params);
    }

    @Override
    public Map<String, Object> getMap(String select, String where, Object... params) {
        return getJdbcDao().getMap(getEntityClass(), select, where, params);
    }

    @Override
    public Map<String, Object> getMap(String select, Query query) {
        Table table = Table.getTable(entityClass);
        List sqlParas = new LinkedList<>();
        String sql = query.buildWhere(table.getTableName(), sqlParas);
        return getMap(select, sql, sqlParas.toArray());
    }



    @Override
    public KEY getId(String where, Object... params) {
        return getColumn(getKeyClass(), "id", where, params);
    }


    //</editor-fold>
}
