package org.jsmth.data.code.sqlbuilder.select;

import org.jsmth.data.code.sqlbuilder.Context;
import org.jsmth.data.code.sqlbuilder.TerminalExpression;
import org.apache.commons.lang.StringUtils;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class From  {

	private Context context;

	private boolean terminated = false;

	private final List<String> tables = new ArrayList<>();

	From(Context context) {
		this.context = context;
		this.context.appendLine("FROM");
	}

	public From table() {
		tables.add(context.getTable().getTableName());
		return this;
	}


	public From select(String selectQuery, String alias) {
		this.tables.add("(" + selectQuery + ") " + alias);
		return this;
	}

	public Where where() {
		terminate();
		return new Where(context);
	}

	public Where where(String condition) {
		terminate();
		return new Where(context, condition);
	}

	public GroupBy groupBy() {
		terminate();
		return new GroupBy(context);
	}

	public GroupBy groupBy(String... columns) {
		terminate();
		return new GroupBy(context, columns);
	}

	public Join leftOuterJoin(String condition) {
		terminate();
		return new LeftOuterJoin(context, condition);
	}

	public Join rightOuterJoin(String condition) {
		terminate();
		return new RightOuterJoin(context, condition);
	}

	public Join innerJoin(String condition) {
		terminate();
		return new InnerJoin(context, condition);
	}

	public OrderBy orderBy() {
		terminate();
		return new OrderBy(context);
	}

	public Limit limit(int start, int size) {
		terminate();
		return new Limit(context, start, size);
	}


	@Override
	public String toString() {
		terminate();
		return context.toString();
	}

	private void terminate() {
		if (!terminated) {
			final String newLine = System.getProperty("line.separator");
			this.context.appendLine(StringUtils.join(tables, "," + newLine));
			this.context.appendLine(newLine);
			terminated = true;
		}
	}
}