package org.jsmth.data.code.sqlbuilder.builder;

import org.jsmth.data.code.sqlbuilder.Context;
import org.jsmth.data.code.sqlbuilder.Database;
import org.jsmth.data.code.sqlbuilder.delete.Delete;
import org.jsmth.data.code.sqlbuilder.insert.Insert;
import org.jsmth.data.code.sqlbuilder.select.Select;
import org.jsmth.data.code.sqlbuilder.update.Update;
import org.jsmth.data.dialect.Dialect;

import javax.sql.DataSource;
import java.sql.Connection;
import java.sql.SQLException;

public class QueryBuilder {

	private final Context context;

	public QueryBuilder(Dialect dialect,Class entityClass) {
		this.context = new Context(dialect, entityClass);
	}

	public static QueryBuilder create(Dialect dialect,Class entityClass){
		return new QueryBuilder(dialect,entityClass);
	}

	public Select select() {
		return new Select(context);
	}

	public Update update() {
		return new Update(context);
	}

	public Update update(String table) {
		return new Update(context, table);
	}

	public Delete delete() {
		return new Delete(context);
	}

	public Delete delete(String table) {
		return new Delete(context, table);
	}

	public Insert insert() {
		return new Insert(context);
	}

	public Insert insert(String table) {
		return new Insert(context, table);
	}

	@Override
	public String toString() {
		return context.toString();
	}

	public Context getContext() {
		return context;
	}
}