package org.jsmth.data.code.sql;


import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/**
 * 描述：
 * author：mason(ma)
 * 日期：16/9/24.
 */
public class Where extends SqlItem {
    public static final Integer LOGIC_AND = 1;
    public static final Integer LOGIC_OR = 2;
    public static final Integer LOGIC_NOT = 3;

    Where(SqlContext context) {
        super(context);
    }


    public Where equal(String column, Object value) {
        return equal(Logic.AND, column, value);
    }

    public Where equal(Logic logic, String column, Object value) {
        String expression = column + " = ?";
        return w(logic, expression, value);
    }

    public Where notEqual(String column, Object value) {
        return notEqual(Logic.AND, column, value);
    }

    public Where notEqual(Logic logic, String column, Object value) {
        String expression = column + " <> ?";
        return w(logic, expression, value);
    }

    public Where greaterThan(Logic logic, String column, Object value, boolean include) {
        StringBuilder builder = new StringBuilder();
        builder.append(column);
        if (include) {
            builder.append(" >= ");
        } else {
            builder.append(" > ");
        }
        builder.append("?");
        return w(logic, builder.toString(), value);
    }

    public Where lessThan(Logic logic, String column, Object value, boolean include) {
        StringBuilder builder = new StringBuilder();
        builder.append(column);
        if (include) {
            builder.append(" <= ");
        } else {
            builder.append(" < ");
        }
        builder.append("?");
        return w(logic, builder.toString(), value);
    }

    public Where between(Logic logic, String column, Object greaterValue, boolean greaterInclude, Logic betweenLogic, Object lessValue, boolean lessInclude) {
        StringBuilder builder = new StringBuilder();
        builder.append("( ");
        builder.append(column);
        if (greaterInclude) {
            builder.append(" <= ");
        } else {
            builder.append(" < ");
        }
        builder.append("?");
        addLogic(betweenLogic, builder);
        builder.append(column);
        if (lessInclude) {
            builder.append(" <= ");
        } else {
            builder.append(" < ");
        }
        builder.append("?");
        builder.append(" )");
        return w(logic, builder.toString(), greaterValue, lessValue);
    }

    public Where w(Logic logic, String expression, Object... params) {
        addLogic(logic, sql);
        sql.append(" ( ");
        sql.append(expression);
        sql.append(" ) ");

        if (params != null) {
            for (Object param : params) {
                sqlParams.add(param);
            }
        }
        return this;
    }


    void addLogic(Logic logic, StringBuilder content) {
        if (content.length() > 0) {
            switch (logic) {
                case AND:
                    content.append(" AND ");
                    break;
                case OR:
                    content.append(" OR ");
                    break;
                case NOT:
                    content.append(" NOT ");
                    break;
            }
        }
    }

    @Override
    public String toString() {
        return toWhere();
    }
    public String toSql() {
        StringBuilder sql=new StringBuilder();
        sql.append("SELECT * ");
        sql.append(" FROM ");
        sql.append(context.getTableName());
        String str = toWhere();
        if(str.length()>0) {
            sql.append(" WHERE ");
            sql.append(str);
        }
        return sql.toString();
    }
    public String toWhere() {
        return sql.toString();
    }
}
