package org.jsmth.data.code.sql;

import java.util.LinkedList;
import java.util.List;

/**
 * 描述：
 * author：mason(ma)
 * 日期：16/9/25.
 */
public class Update extends SqlItem {
    List<String> columns;

    public Update(SqlContext context) {
        super(context);
        this.context = context;
        columns=new LinkedList<>();
    }

    public Update i(String column,Object value){
        columns.add(column);
        sqlParams.add(value);

        return this;
    }
    public Update i(Object model,boolean exclude,String... columnNames){
        SqlContext cxt=new SqlContext(model.getClass(),context);
        for (Object o : cxt.findAllColumns()) {
            ColumnSchema c=(ColumnSchema)o;
            boolean include=false;
            if(columnNames!=null){
                for (String columnName : columnNames) {
                    if(c.getColumnName().equals(columnName)){
                        include=true;
                    }
                }
            }
            if((!exclude && include) || (exclude && !include)){
                i(c.getColumnName(),cxt.getColumnValue(model,c.getFieldName()));
            }
        }
        return this;
    }

    @Override
    public String toString() {
        return toSql(null);
    }
    public String toSql(Where where) {
        StringBuilder sql=new StringBuilder();
        sql.append("UPDATE set ");
        sql.append(toFieldValues());
        String s ="";
        if(where!=null) {
            where.toWhere();
        }
        if(s.length()>0){
            sql.append(" WHERE ");
            sql.append(s);
        }
        return sql.toString();
    }
    public String toFieldValues() {
        StringBuilder sql=new StringBuilder();
        for (String column : columns) {
            if(sql.length()>0){
                sql.append(",");
            }
            sql.append(context.getColumnAlias(column));
            sql.append("=?");
        }
        return sql.toString();
    }

}
