package org.jsmth.data.code.sql;

import java.util.List;

/**
 * 描述：
 * author：mason(ma)
 * 日期：16/9/24.
 */
public class Select extends SqlItem {
    SqlContext context;
    Where where;
    StringBuilder select;
    StringBuilder group;
    StringBuilder order;


    Select(SqlContext context) {
        super(context);
        where = new Where(context);
        select=new StringBuilder();
        group=new StringBuilder();
        order=new StringBuilder();
    }

    //<editor-fold desc="where">
    public Select equal(String column, Object value) {
        where.equal(column, value);
        return this;
    }

    public Select equal(Logic logic, String column, Object value) {
        where.equal(logic, column, value);
        return this;
    }

    public Select w(Logic logic, String expression, Object... params) {
        where.w(logic, expression, params);
        return this;
    }

    public Select notEqual(String column, Object value) {
        where.notEqual(column, value);
        return this;
    }


    public Select notEqual(Logic logic, String column, Object value) {
        where.notEqual(logic, column, value);
        return this;
    }

    public Select greaterThan(Logic logic, String column, Object value, boolean include) {
        where.greaterThan(logic, column, value, include);
        return this;
    }

    public Select between(Logic logic, String column, Object greaterValue, boolean greaterInclude, Logic betweenLogic, Object lessValue, boolean lessInclude) {
        where.between(logic, column, greaterValue, greaterInclude, betweenLogic, lessValue, lessInclude);
        return this;
    }

    public Select lessThan(Logic logic, String column, Object value, boolean include) {
        where.lessThan(logic, column, value, include);
        return this;
    }

    //</editor-fold>
    //<editor-fold desc="select">
    public Select s(String expression) {
        if (select.length() > 0) {
            select.append(",");
        }
        select.append("");
        select.append(expression);
        return this;
    }

    public Select s_all() {
        s("*");
        return this;
    }

    public Select s_max(String column) {
        s("MAX(" + column + ")");
        return this;
    }

    public Select s_max(String column, String asName) {
        s("MAX(" + column + ") as " + asName);
        return this;
    }

    public Select s_min(String column) {
        s("MIN(" + column + ")");
        return this;
    }

    public Select s_min(String column, String asName) {
        s("MIN(" + column + ") as " + asName);
        return this;
    }

    public Select s_avg(String column) {
        s("AVG(" + column + ")");
        return this;
    }

    public Select s_avg(String column, String asName) {
        s("AVG(" + column + ") as " + asName);
        return this;
    }

    public Select s_countAll() {
        s("COUNT(*)");
        return this;
    }

    public Select s_countAll(String asName) {
        s("COUNT(*) as " + asName);
        return this;
    }

    public Select s_count(String column) {
        s("COUNT(" + column + ")");
        return this;
    }

    public Select s_count(String column, String asName) {
        s("COUNT(" + column + ") as " + asName);
        return this;
    }

    //</editor-fold>
    //<editor-fold desc="group">
    public Select g(String expression) {
        if (group.length() > 0) {
            group.append(",");
        }
        group.append(expression);
        return this;
    }

    public Select g_column(String column) {
        g(column);
        return this;
    }

    //</editor-fold>
    //<editor-fold desc="order">
    public Select o(String expression) {
        if (order.length() > 0) {
            order.append(",");
        }
        order.append(expression);
        return this;
    }

    public Select o_column(String column) {
        o(column);
        return this;
    }
    //</editor-fold>


    @Override
    public List<Object> getSqlParams() {
        return where.getSqlParams();
    }

    @Override
    public void setSqlParams(List<Object> sqlParams) {
        where.setSqlParams(sqlParams);
    }

    @Override
    public String toString() {
        return toSql();
    }
    public String toSql() {
        StringBuilder sql=new StringBuilder();
        sql.append("SELECT ");
        sql.append(select.toString());
        sql.append(" FROM ");
        sql.append(context.getTableName());
        if(where.toString().length()>0) {
            sql.append(" WHERE ");
            sql.append(where.toString());
        }
        if(group.length()>0) {
            sql.append(" GROUP BY ");
            sql.append(group.toString());
        }
        if(order.length()>0) {
            sql.append(" ORDER BY ");
            sql.append(order.toString());
        }
        return sql.toString();
    }
    public String toWhere() {
        return where.toString();
    }
}
