package org.jsmth.data.code.sql;

import org.apache.commons.beanutils.converters.ShortConverter;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.lang.StringUtils;
import org.jsmth.data.dialect.Dialect;
import org.jsmth.data.dialect.DialectFactory;
import org.jsmth.data.jdbc.MapSqlParameterSourceEx;
import org.jsmth.data.jdbc.SmthDataSource;
import org.jsmth.data.sql.EntityInsert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.PreparedStatementCreator;
import org.springframework.jdbc.core.PreparedStatementSetter;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcDaoSupport;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;

import javax.sql.DataSource;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 描述：
 * author：mason(ma)
 * 日期：16/9/25.
 */
public class JdbcDao {

    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    Dialect dialect;
    DataSource dataSource;
    NamedParameterJdbcDaoSupport daoSupport;

    //<editor-fold desc="BaseJdbcDao">
    public JdbcDao(DataSource dataSource) {
        this(dataSource, (Dialect) null);
    }

    public JdbcDao(SmthDataSource dataSource) {
        this(dataSource, dataSource.getDialect());
    }

    public JdbcDao(DataSource dataSource, String dialectString) {
        this(dataSource, (Dialect) null);
        if (StringUtils.isNotBlank(dialectString)) {
            this.dialect = DialectFactory.getDialect(dialectString);
        } else {
            if (SmthDataSource.class.isAssignableFrom(dataSource.getClass())) {
                SmthDataSource ds = (SmthDataSource) dataSource;
                this.dialect = ds.getDialect();
            } else {
                this.dialect = DialectFactory.getDialect((BasicDataSource) dataSource);
            }
        }
    }

    JdbcDao(DataSource dataSource, Dialect dialect) {
        this.dataSource = dataSource;
        daoSupport = new NamedParameterJdbcDaoSupport();
        if (dialect == null) {
            if (SmthDataSource.class.isAssignableFrom(dataSource.getClass())) {
                SmthDataSource ds = (SmthDataSource) dataSource;
                this.dialect = ds.getDialect();
            } else {
                this.dialect = DialectFactory.getDialect((BasicDataSource) dataSource);
            }
        } else {
            this.dialect = dialect;
        }
    }

    //</editor-fold>
    //<editor-fold desc="Base method">
    public <RT> RT insert(Insert insert, Class<RT> returnClass) {
        String sql = insert.getSql();
        List<Object> sqlParams = insert.getSqlParams();
        PreparedStatementCreator statementCreator=new JdbcPreparedStatementCreator(sql, sqlParams);
        NamedParameterJdbcTemplate jdbcTemplate = daoSupport.getNamedParameterJdbcTemplate();
        if (insert.getContext().isAutoId()) {
            KeyHolder keyHolder = new GeneratedKeyHolder();
            jdbcTemplate.getJdbcOperations().update(statementCreator, keyHolder);
            Number number = keyHolder.getKey();
            if(returnClass.equals(Integer.class)){
                return (RT)Integer.valueOf( number.intValue());
            }
            if(returnClass.equals(Byte.class)){
                return (RT)Byte.valueOf( number.byteValue());
            }
            if(returnClass.equals(Short.class)){
                return (RT)Short.valueOf( number.shortValue());
            }
            if(returnClass.equals(Double.class)){
                return (RT)Double.valueOf( number.doubleValue());
            }
            if(returnClass.equals(Float.class)){
                return (RT)Float.valueOf( number.floatValue());
            }
            if(returnClass.equals(Long.class)){
                return (RT)Long.valueOf( number.longValue());
            }
        }else{
            jdbcTemplate.getJdbcOperations().update(statementCreator);
        }
        return (RT)null;
    }

    public int delete(Where where) {
        String sql = where.getSql();
        List<Object> sqlParams = where.getSqlParams();
        return executeDml(sql,sqlParams);
    }

    public int update(Update update, Where where) {
        String sql = update.getSql();
        List<Object> sqlParams = update.getSqlParams();
        return executeDml(sql,sqlParams);
    }

    public <T> int update(T model, Where where) {
        return 0;
    }

    public <T> List<T> queryModel(Class<T> entityClass, Select select) {
        NamedParameterJdbcTemplate jdbcTemplate = daoSupport.getNamedParameterJdbcTemplate();
        //jdbcTemplate.qu
        return null;
    }
    //</editor-fold>


    int executeDml(String sql,List<Object> sqlParams){
        PreparedStatementCreator statementCreator=new JdbcPreparedStatementCreator(sql, sqlParams);
        NamedParameterJdbcTemplate jdbcTemplate = daoSupport.getNamedParameterJdbcTemplate();
        return jdbcTemplate.getJdbcOperations().update(sql,statementCreator);
    }



    class JdbcPreparedStatementCreator implements PreparedStatementCreator{
        String sql="";
        List<Object> sqlParams;

        public JdbcPreparedStatementCreator(String sql, List<Object> sqlParams) {
            this.sql = sql;
            this.sqlParams = sqlParams;
        }

        @Override
        public PreparedStatement createPreparedStatement(
                Connection con) throws SQLException {
            PreparedStatement ps = con.prepareStatement(sql, Statement.RETURN_GENERATED_KEYS);
            int index = 1;
            for (Object sqlParam : sqlParams) {
                ps.setObject(index, sqlParam);
                index++;
            }
            return ps;
        }

        public String getSql() {
            return sql;
        }

        public void setSql(String sql) {
            this.sql = sql;
        }

        public List<Object> getSqlParams() {
            return sqlParams;
        }

        public void setSqlParams(List<Object> sqlParams) {
            this.sqlParams = sqlParams;
        }
    }
}
