package org.jsmth.data.code.sql;

import java.lang.reflect.Type;
import java.util.LinkedList;
import java.util.List;

/**
 * 描述：
 * author：mason(ma)
 * 日期：16/9/25.
 */
public class Insert  extends SqlItem{
    List<String> columns;
    List<Object> values;
    Class returnClass;

    public Insert(SqlContext context) {
        super(context);
        columns=new LinkedList<>();
        values=new LinkedList<>();
        returnClass=String.class;
    }

    public Insert i(String column,Object value){
        columns.add(column);
        values.add(value);

        return this;
    }
    public Insert i(Object model,boolean exclude,String... columnNames){
        SqlContext cxt=new SqlContext(model.getClass(),context);
        for (Object o : cxt.findAllColumns()) {
            ColumnSchema c=(ColumnSchema)o;
            boolean include=false;
            if(columnNames!=null){
                for (String columnName : columnNames) {
                    if(c.getColumnName().equals(columnName)){
                        include=true;
                    }
                }
            }
            if((!exclude && include) || (exclude && !include)){
                i(c.getColumnName(),cxt.getColumnValue(model,c.getFieldName()));
            }
        }
        return this;
    }

    @Override
    public String toString() {
        return toSql();
    }
    public String toSql() {
        StringBuilder sql=new StringBuilder();
        sql.append("INSET (");
        sql.append(toFields());
        sql.append(") VALUES (");
        sql.append(toValues());
        sql.append(")");
        return sql.toString();
    }
    public String toFields() {
        StringBuilder sql=new StringBuilder();
        for (String column : columns) {
            if(sql.length()>0){
                sql.append(",");
            }
            sql.append(context.getColumnAlias(column));
        }
        return sql.toString();
    }
    public String toValues() {
        StringBuilder sql=new StringBuilder();
        for (String column : columns) {
            if(sql.length()>0){
                sql.append(",");
            }
            sql.append("?");
        }
        return sql.toString();
    }
}
