package org.jsmth.data.code.hql;

import org.jsmth.data.code.hql.item.Group;
import org.jsmth.data.code.hql.item.Having;
import org.jsmth.data.code.hql.item.Order;
import org.jsmth.data.code.hql.item.Where;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

/**
 * 描述：
 * author：mason(ma)
 * 日期：16/8/24.
 */
public class Select {
    private Context context;
    private final List<String> columns;
    private final List sqlParams;
    Where where;
    Order order;
    Group group;
    Having having;

    public Select(Context context) {
        this.context=context;
        columns = new LinkedList<>();
        sqlParams=new ArrayList<>();
    }

    public String toSql(){
        return "";
    }

    public Select all() {
        append("*");
        return this;
    }

    public Select column(String column) {
        append(column);
        return this;
    }

    public Select columns(String... columns) {
        for (String column : columns) {
            append(column);
        }

        return this;
    }

    public Select count(String column) {
        append("COUNT(" + column + ")");
        return this;
    }

    private void append(String expression) {
        columns.add(expression);
    }


    public Where getWhere() {
        return where;
    }

    public void setWhere(Where where) {
        this.where = where;
    }

    public Context getContext() {
        return context;
    }

    public Order getOrder() {
        return order;
    }

    public void setOrder(Order order) {
        this.order = order;
    }

    public Group getGroup() {
        return group;
    }

    public void setGroup(Group group) {
        this.group = group;
    }

    public Having getHaving() {
        return having;
    }

    public void setHaving(Having having) {
        this.having = having;
    }
}
