package org.jsmth.data.code.hql;

import org.jsmth.data.dialect.Dialect;

/**
 * 描述：
 * author：mason(ma)
 * 日期：16/8/24.
 */
public class Builder {
    private final Context context;

    public Builder(Class entityClass) {
        context=new Context(entityClass);
    }
    public Builder(Class entityClass, Dialect dialect) {
        context=new Context(entityClass,dialect);
    }

    public static Builder create(Class entityClass, Dialect dialect) {
        return new Builder(entityClass, dialect);
    }
    public Select select(){
        return new Select(context);
    }
    public Update update(){
        return new Update(context);
    }
    public Delete delete(){
        return new Delete(context);
    }
    public Insert insert(){
        return new Insert(context);
    }
}
