package org.jsmth.data.cache;

import org.jsmth.domain.Identifier;
import org.jsmth.util.IdentifierKeyHelper;
import org.jsmth.jorm.service.EntityDao;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * User: 马生录（mason
 * Date: 12-1-17
 * Time: 下午11:03
 */
public class ItemCache<KEY extends java.io.Serializable, MODEL extends Identifier<KEY>, ENTITYDAO extends EntityDao<KEY, MODEL>> {
    ENTITYDAO entityDao;
    String where;

    public ItemCache() {
    }

    public ItemCache(ENTITYDAO entityDao) {
        this.entityDao = entityDao;
    }

    public String getWhere() {
        return where;
    }

    public void setWhere(String where) {
        this.where = where;
    }

    public ENTITYDAO getEntityDao() {
        return entityDao;
    }

    public void setEntityDao(ENTITYDAO entityDao) {
        this.entityDao = entityDao;
    }

    protected Map<KEY, MODEL> modelCaches = new HashMap<KEY, MODEL>();
    protected Map<KEY, List<MODEL>> modelsCaches = new HashMap<KEY, List<MODEL>>();
    protected Map<KEY, List<KEY>> modelIdCaches = new HashMap<KEY, List<KEY>>();

    public MODEL getItem(KEY id) {
        MODEL model;
        if (modelCaches.containsKey(id))
            model = modelCaches.get(id);
        else {
            model = entityDao.getById(id);
            modelCaches.put(id, model);
        }
        return model;
    }

    public List<MODEL> getItems(KEY id) {
        return getItems(id, where);
    }

    public List<MODEL> getItems(KEY id, String where) {
        List<MODEL> models;
        if (modelsCaches.containsKey(id))
            models = modelsCaches.get(id);
        else {
            models = entityDao.findModels(String.format(where, id));
            modelsCaches.put(id, models);
        }
        return models;
    }

    public List<KEY> getIds(KEY id) {
        return getIds(id, this.where);
    }

    public List<KEY> getIds(KEY id, String where) {
        List<KEY> models;
        if (modelIdCaches.containsKey(id))
            models = modelIdCaches.get(id);
        else {
            models = entityDao.findIds(String.format(where, id));
            modelIdCaches.put(id, models);
        }


        return models;
    }

    public <T> List<T> getFields(Class<T> fieldClass, KEY id, String fieldName) {
        return getFields(fieldClass, id, fieldName,this.where);
    }

    public <T> List<T> getFields(Class<T> fieldClass, KEY id, String fieldName, String where) {
        List<MODEL> models = getItems(id, where);
        List<T> list = IdentifierKeyHelper.getFields(models, fieldName);
        return list;
    }

}
