package org.jsmth.data.cache;

import java.util.Collection;
import java.util.Date;
import java.util.Set;

/**
 * User: 马生录（mason
 * Date: 12-1-17
 * Time: 下午11:01
 */
public interface ICache<K,V>{
    /**
     * 保存数据
     * @param key ff
     * @param value ff
     * @return 返回信息
     */
    public V put(K key, V value);

    /**
     * 保存有有效期的数据
     * @param key ff
     * @param value ff
     * @param expiry ff
     * @return 返回信息
     */
    public V put(K key, V value, Date expiry);

    /**
     * 保存有有效期的数据
     * @param key ff
     * @param value ff
     * @param TTL//数据超时的秒数
     * @return 返回信息
     */
    public V put(K key, V value, int TTL);

    /**
     * 获取缓存数据
     * @param key ff
     * @return 返回信息
     */
    public V get(K key);

    /**
     * 移出缓存数据
     * @param key ff
     * @return 返回信息
     */
    public V remove(K key);

    /**
     * 删除所有缓存内的数据
     * @return 返回信息
     */
    public boolean clear();

    /**
     * 缓存数据数量
     * @return 返回信息
     */
    public int size();

    /**
     * 缓存所有的key的集合
     * @return 返回信息
     */
    public Set<K> keySet();

    /**
     * 缓存的所有value的集合
     * @return 返回信息
     */
    public Collection<V> values();

    /**
     * 是否包含了指定key的数据
     * @param key ff
     * @return 返回信息
     */
    public boolean containsKey(K key);

    /**
     * 释放Cache占用的资源
     */
    public void destroy();


}

