/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.generate.gen;

import cn.net.vidyo.framework.generate.gen.ColumnDefinition;
import cn.net.vidyo.framework.generate.gen.TypeEnum;
import cn.net.vidyo.framework.generate.gen.converter.ColumnTypeConverter;
import cn.net.vidyo.framework.generate.gen.converter.JavaColumnTypeConverter;
import cn.net.vidyo.framework.generate.util.FieldUtil;
import java.util.HashMap;
import java.util.Map;

public class JavaColumnDefinition
extends ColumnDefinition {
    private static final JavaColumnTypeConverter COLUMN_TYPE_CONVERTER = new JavaColumnTypeConverter();
    private static final Map<String, String> TYPE_MYBATIS_MAP = new HashMap<String, String>(64);

    public String getMybatisJdbcType() {
        return TYPE_MYBATIS_MAP.getOrDefault(this.getType(), "VARCHAR");
    }

    public String getJavaFieldNameUF() {
        return FieldUtil.upperFirstLetter(this.getJavaFieldName());
    }

    public String getJavaFieldName() {
        return FieldUtil.underlineFilter(this.getColumnName());
    }

    public String getJavaType() {
        return this.getFieldType();
    }

    public String getJavaTypeBox() {
        return this.getFieldTypeBox();
    }

    @Override
    public ColumnTypeConverter getColumnTypeConverter() {
        return COLUMN_TYPE_CONVERTER;
    }

    static {
        TYPE_MYBATIS_MAP.put(TypeEnum.BIT.getType(), "BOOLEAN");
        TYPE_MYBATIS_MAP.put(TypeEnum.BOOLEAN.getType(), "BOOLEAN");
        TYPE_MYBATIS_MAP.put(TypeEnum.TINYINT.getType(), "TINYINT");
        TYPE_MYBATIS_MAP.put(TypeEnum.SMALLINT.getType(), "INTEGER");
        TYPE_MYBATIS_MAP.put(TypeEnum.INT.getType(), "INTEGER");
        TYPE_MYBATIS_MAP.put(TypeEnum.BIGINT.getType(), "BIGINT");
        TYPE_MYBATIS_MAP.put(TypeEnum.FLOAT.getType(), "FLOAT");
        TYPE_MYBATIS_MAP.put(TypeEnum.DOUBLE.getType(), "DOUBLE");
        TYPE_MYBATIS_MAP.put(TypeEnum.DECIMAL.getType(), "DECIMAL");
        TYPE_MYBATIS_MAP.put(TypeEnum.VARCHAR.getType(), "VARCHAR");
        TYPE_MYBATIS_MAP.put(TypeEnum.DATETIME.getType(), "TIMESTAMP");
        TYPE_MYBATIS_MAP.put(TypeEnum.BLOB.getType(), "BLOB");
    }
}

