/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.builder.converts;

import cn.net.vidyo.framework.builder.config.GlobalConfig;
import cn.net.vidyo.framework.builder.converts.TypeConverts;
import cn.net.vidyo.framework.builder.domain.DbColumnType;
import cn.net.vidyo.framework.builder.domain.IColumnType;
import cn.net.vidyo.framework.builder.domain.ITypeConvert;
import java.util.function.Function;

public class MySqlTypeConvert
implements ITypeConvert {
    public static final MySqlTypeConvert INSTANCE = new MySqlTypeConvert();

    @Override
    public IColumnType processTypeConvert(GlobalConfig config, String fieldType) {
        return (IColumnType)((Object)TypeConverts.use(fieldType).test(TypeConverts.containsAny("char", "text", "json", "enum").then(DbColumnType.STRING)).test(TypeConverts.contains("bigint").then(DbColumnType.LONG)).test(TypeConverts.containsAny("tinyint(1)", "bit(1)").then(DbColumnType.BOOLEAN)).test(TypeConverts.contains("bit").then(DbColumnType.BOOLEAN)).test(TypeConverts.contains("int").then(DbColumnType.INTEGER)).test(TypeConverts.contains("decimal").then(DbColumnType.BIG_DECIMAL)).test(TypeConverts.contains("clob").then(DbColumnType.CLOB)).test(TypeConverts.contains("blob").then(DbColumnType.BLOB)).test(TypeConverts.contains("binary").then(DbColumnType.BYTE_ARRAY)).test(TypeConverts.contains("float").then(DbColumnType.FLOAT)).test(TypeConverts.contains("double").then(DbColumnType.DOUBLE)).test(TypeConverts.containsAny("date", "time", "year").then((IColumnType)((Object)((Function<String, IColumnType>)t -> MySqlTypeConvert.toDateType(config, t))))).or((Function<String, IColumnType>)((Object)DbColumnType.STRING)));
    }

    public static IColumnType toDateType(GlobalConfig config, String type) {
        String dateType = type.replaceAll("\\(\\d+\\)", "");
        switch (config.getDateType()) {
            case ONLY_DATE: {
                return DbColumnType.DATE;
            }
            case SQL_PACK: {
                switch (dateType) {
                    case "date": 
                    case "year": {
                        return DbColumnType.DATE_SQL;
                    }
                    case "time": {
                        return DbColumnType.TIME;
                    }
                }
                return DbColumnType.TIMESTAMP;
            }
            case TIME_PACK: {
                switch (dateType) {
                    case "date": {
                        return DbColumnType.LOCAL_DATE;
                    }
                    case "time": {
                        return DbColumnType.LOCAL_TIME;
                    }
                    case "year": {
                        return DbColumnType.YEAR;
                    }
                }
                return DbColumnType.LOCAL_DATE_TIME;
            }
        }
        return DbColumnType.STRING;
    }
}

