/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.builder.meta;

import cn.net.vidyo.framework.builder.domain.DbColumnType;
import cn.net.vidyo.framework.builder.meta.ColumnSchema;
import cn.net.vidyo.framework.builder.meta.ForeignKeySchema;
import cn.net.vidyo.framework.common.util.ValueUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TableSchema {
    String schemaName = "";
    String name = "";
    String entityName = "";
    String comment = "";
    boolean identityIncrement = false;
    Map<String, ColumnSchema> columnNameMap = new HashMap<String, ColumnSchema>();
    List<ColumnSchema> columns = new ArrayList<ColumnSchema>();
    List<String> excludeColumns = new ArrayList<String>();
    ColumnSchema idColumn = null;
    boolean includeStatus = false;
    boolean includeName = false;
    boolean includeExtend = false;
    boolean includePid = false;
    List<ForeignKeySchema> parentForeignKeys = new ArrayList<ForeignKeySchema>();
    List<ForeignKeySchema> childForeignKeys = new ArrayList<ForeignKeySchema>();

    public TableSchema() {
        this.excludeColumns.add("id");
        this.excludeColumns.add("hidden");
        this.excludeColumns.add("createtime");
        this.excludeColumns.add("updatetime");
    }

    public boolean includeColumn(String name) {
        for (ColumnSchema column : this.columns) {
            if (!column.name.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public List<ColumnSchema> getIncludeColumns() {
        ArrayList<ColumnSchema> list = new ArrayList<ColumnSchema>();
        for (ColumnSchema column : this.columns) {
            if (this.excludeColumns.contains(column.getName().toLowerCase())) continue;
            list.add(column);
        }
        return list;
    }

    public void addParentForeignKey(ForeignKeySchema foreignKeySchema) {
        this.parentForeignKeys.add(foreignKeySchema);
    }

    public void addChildForeignKey(ForeignKeySchema foreignKeySchema) {
        this.childForeignKeys.add(foreignKeySchema);
    }

    public void addColumn(ColumnSchema columnSchema) {
        if (this.columnNameMap.containsKey(columnSchema.getName())) {
            return;
        }
        this.columnNameMap.put(columnSchema.getName(), columnSchema);
        this.columns.add(columnSchema);
        if (columnSchema.getName() == "id") {
            this.idColumn = columnSchema;
        }
    }

    public String firstCapitalLetterName() {
        return ValueUtil.firstCapitalLetterName((String)this.name);
    }

    public String getBaseClassString() {
        DbColumnType columnType = (DbColumnType)this.getIdColumn().getColumnType();
        if (columnType == DbColumnType.STRING) {
            return "StringModel";
        }
        if (columnType == DbColumnType.BIG_INTEGER || columnType == DbColumnType.LONG || columnType == DbColumnType.BASE_LONG) {
            return "AutoLongModel";
        }
        if (columnType == DbColumnType.INTEGER || columnType == DbColumnType.BASE_INT) {
            return "AutoIntModel";
        }
        if (columnType == null) {
            System.out.println("columnType is null");
        } else {
            System.out.println("columnType is " + columnType);
        }
        return "";
    }

    public String getKeyClassString() {
        DbColumnType columnType = (DbColumnType)this.getIdColumn().getColumnType();
        if (columnType == DbColumnType.STRING) {
            return "String";
        }
        if (columnType == DbColumnType.BIG_INTEGER || columnType == DbColumnType.LONG || columnType == DbColumnType.BASE_LONG) {
            return "Long";
        }
        if (columnType == DbColumnType.INTEGER || columnType == DbColumnType.BASE_INT) {
            return "Integer";
        }
        if (columnType == null) {
            System.out.println("columnType is null");
        } else {
            System.out.println("columnType is " + columnType);
        }
        return "";
    }

    public List<ForeignKeySchema> getParentForeignKeys() {
        return this.parentForeignKeys;
    }

    public void setParentForeignKeys(List<ForeignKeySchema> parentForeignKeys) {
        this.parentForeignKeys = parentForeignKeys;
    }

    public List<ForeignKeySchema> getChildForeignKeys() {
        return this.childForeignKeys;
    }

    public void setChildForeignKeys(List<ForeignKeySchema> childForeignKeys) {
        this.childForeignKeys = childForeignKeys;
    }

    public boolean isIdentityIncrement() {
        return this.identityIncrement;
    }

    public void setIdentityIncrement(boolean identityIncrement) {
        this.identityIncrement = identityIncrement;
    }

    public boolean isIncludeName() {
        return this.includeName;
    }

    public void setIncludeName(boolean includeName) {
        this.includeName = includeName;
    }

    public boolean isIncludeStatus() {
        return this.includeStatus;
    }

    public void setIncludeStatus(boolean includeStatus) {
        this.includeStatus = includeStatus;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = ValueUtil.firstLowercaseLetterName((String)name);
        this.entityName = this.firstCapitalLetterName();
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public List<ColumnSchema> getColumns() {
        return this.columns;
    }

    public void setColumns(List<ColumnSchema> columns) {
        this.columns = columns;
    }

    public List<String> getExcludeColumns() {
        return this.excludeColumns;
    }

    public void setExcludeColumns(List<String> excludeColumns) {
        this.excludeColumns = excludeColumns;
    }

    public ColumnSchema getIdColumn() {
        return this.idColumn;
    }

    public void setIdColumn(ColumnSchema idColumn) {
        this.idColumn = idColumn;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public boolean isIncludeExtend() {
        return this.includeExtend;
    }

    public void setIncludeExtend(boolean includeExtend) {
        this.includeExtend = includeExtend;
    }

    public boolean isIncludePid() {
        return this.includePid;
    }

    public void setIncludePid(boolean includePid) {
        this.includePid = includePid;
    }
}

