/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.builder.database.querys;

import cn.net.vidyo.framework.builder.config.DataSourceConfig;
import cn.net.vidyo.framework.builder.database.domain.IDbQuery;
import cn.net.vidyo.framework.builder.database.querys.AbstractDbQuery;
import cn.net.vidyo.framework.builder.domain.DbType;
import cn.net.vidyo.framework.common.util.ValueUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbQueryDecorator
extends AbstractDbQuery {
    private final IDbQuery dbQuery;
    private final DbType dbType;
    private final String schema;
    private final Logger logger;

    public DbQueryDecorator(DataSourceConfig dataSourceConfig) {
        this.dbQuery = dataSourceConfig.getDbQuery();
        this.dbType = dataSourceConfig.getDbType();
        this.schema = dataSourceConfig.getSchemaName();
        this.logger = LoggerFactory.getLogger(this.dbQuery.getClass());
    }

    @Override
    public String tablesSql() {
        String tablesSql = this.dbQuery.tablesSql();
        if (DbType.POSTGRE_SQL == this.dbType || DbType.KINGBASE_ES == this.dbType || DbType.DB2 == this.dbType || DbType.ORACLE == this.dbType) {
            tablesSql = String.format(tablesSql, this.schema);
        }
        return tablesSql;
    }

    @Override
    public String tableFieldsSql() {
        return this.dbQuery.tableFieldsSql();
    }

    public String tableFieldsSql(String tableName) {
        String tableFieldsSql = this.tableFieldsSql();
        if (DbType.KINGBASE_ES == this.dbType || DbType.DB2 == this.dbType) {
            tableFieldsSql = String.format(tableFieldsSql, this.schema, tableName);
        } else if (DbType.ORACLE == this.dbType) {
            tableFieldsSql = String.format(tableFieldsSql.replace("#schema", this.schema), tableName, tableName.toUpperCase());
        } else if (DbType.DM == this.dbType) {
            tableName = tableName.toUpperCase();
            tableFieldsSql = String.format(tableFieldsSql, tableName);
        } else {
            tableFieldsSql = DbType.POSTGRE_SQL == this.dbType ? String.format(tableFieldsSql, tableName, tableName, tableName) : String.format(tableFieldsSql, tableName);
        }
        return tableFieldsSql;
    }

    @Override
    public String tableName() {
        return this.dbQuery.tableName();
    }

    @Override
    public String tableComment() {
        return this.dbQuery.tableComment();
    }

    @Override
    public String fieldName() {
        return this.dbQuery.fieldName();
    }

    @Override
    public String fieldType() {
        return this.dbQuery.fieldType();
    }

    @Override
    public String fieldComment() {
        return this.dbQuery.fieldComment();
    }

    @Override
    public String fieldKey() {
        return this.dbQuery.fieldKey();
    }

    @Override
    public boolean isKeyIdentity(ResultSet results) {
        try {
            return this.dbQuery.isKeyIdentity(results);
        }
        catch (SQLException e) {
            this.logger.warn("\u5224\u65ad\u4e3b\u952e\u81ea\u589e\u9519\u8bef:{}", (Object)e.getMessage());
            return false;
        }
    }

    @Override
    public String[] fieldCustom() {
        return this.dbQuery.fieldCustom();
    }

    public Map<String, Object> getCustomFields(ResultSet resultSet) {
        String[] fcs = this.fieldCustom();
        if (null != fcs) {
            HashMap customMap = ValueUtil.newHashMapWithExpectedSize((int)fcs.length);
            for (String fc : fcs) {
                try {
                    customMap.put(fc, resultSet.getObject(fc));
                }
                catch (SQLException sqlException) {
                    throw new RuntimeException("\u83b7\u53d6\u81ea\u5b9a\u4e49\u5b57\u6bb5\u9519\u8bef:", sqlException);
                }
            }
            return customMap;
        }
        return Collections.emptyMap();
    }
}

