/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.builder.database.query;

import cn.net.vidyo.framework.builder.config.DataSourceConfig;
import cn.net.vidyo.framework.builder.database.query.AbstractDatabaseQuery;
import cn.net.vidyo.framework.builder.database.query.ConnectManager;
import cn.net.vidyo.framework.builder.database.query.DatabaseMetaDataWrapper;
import cn.net.vidyo.framework.builder.database.querys.DbQueryDecorator;
import cn.net.vidyo.framework.builder.domain.DateType;
import cn.net.vidyo.framework.builder.domain.IColumnType;
import cn.net.vidyo.framework.builder.meta.ColumnSchema;
import cn.net.vidyo.framework.builder.meta.TableSchema;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDatabaseQuery
extends AbstractDatabaseQuery {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDatabaseQuery.class);
    private final DbQueryDecorator dbQuery;
    private final DatabaseMetaDataWrapper databaseMetaDataWrapper;
    ConnectManager connectManager;
    private static final Pattern REGX = Pattern.compile("[~!/@#$%^&*()+\\\\\\[\\]|{};:'\",<.>?]+");

    public DefaultDatabaseQuery(DataSourceConfig dataSourceConfig) {
        super(dataSourceConfig);
        this.dbQuery = new DbQueryDecorator(dataSourceConfig);
        this.connectManager = new ConnectManager(dataSourceConfig);
        this.databaseMetaDataWrapper = new DatabaseMetaDataWrapper(this.connectManager.getConnection());
    }

    @Override
    public List<TableSchema> queryTables() {
        ArrayList<TableSchema> tableList = new ArrayList<TableSchema>();
        ArrayList includeTableList = new ArrayList();
        ArrayList excludeTableList = new ArrayList();
        try {
            this.connectManager.execute(this.dbQuery.tablesSql(), result -> {
                String tableName = result.getStringResult(this.dbQuery.tableName());
                if (StringUtils.isNotBlank((CharSequence)tableName)) {
                    DatabaseMetaDataWrapper.Table table = this.databaseMetaDataWrapper.getTableInfo(tableName);
                    TableSchema tableInfo = new TableSchema();
                    tableInfo.setName(tableName);
                    tableList.add(tableInfo);
                }
            });
            tableList.forEach(this::convertTableFields);
            ArrayList<TableSchema> arrayList = tableList;
            return arrayList;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.connectManager.closeConnection();
        }
    }

    public static boolean matcherRegTable(String tableName) {
        return REGX.matcher(tableName).find();
    }

    private void convertTableFields(TableSchema tableInfo) {
        String tableName = tableInfo.getName();
        try {
            HashMap<String, DatabaseMetaDataWrapper.ColumnsInfo> columnsMetaInfoMap = new HashMap<String, DatabaseMetaDataWrapper.ColumnsInfo>();
            Map<String, DatabaseMetaDataWrapper.ColumnsInfo> columnsInfoMap = this.databaseMetaDataWrapper.getColumnsInfo(tableName);
            if (columnsInfoMap != null && !columnsInfoMap.isEmpty()) {
                columnsMetaInfoMap.putAll(columnsInfoMap);
            }
            String tableFieldsSql = this.dbQuery.tableFieldsSql(tableName);
            this.connectManager.execute(tableFieldsSql, result -> {
                String columnName = result.getStringResult(this.dbQuery.fieldName());
                ColumnSchema field = new ColumnSchema();
                field.setName(columnName);
                DatabaseMetaDataWrapper.ColumnsInfo columnsInfo = (DatabaseMetaDataWrapper.ColumnsInfo)columnsMetaInfoMap.get(columnName.toLowerCase());
                if (columnsInfo.isPrimaryKey()) {
                    field.setPrimaryKey(columnsInfo.isAutoIncrement());
                    tableInfo.setIdColumn(field);
                }
                field.setName(columnName);
                field.setDbColumnTypeString(result.getStringResult(this.dbQuery.fieldType()));
                String typeName = field.getDbColumnTypeString();
                int pos = typeName.indexOf("(");
                if (pos > 0) {
                    typeName = typeName.substring(0, pos);
                }
                field.setDataTypeName(typeName);
                field.setComment(columnsInfo.getRemarks());
                field.setCustomMap(this.dbQuery.getCustomFields(result.getResultSet()));
                IColumnType columnType = this.dataSourceConfig.getTypeConvert().processTypeConvert(DateType.TIME_PACK, field);
                field.setPropertyName(columnsInfo.getName());
                field.setColumnType(columnType);
                if (columnName.equalsIgnoreCase("status")) {
                    System.out.println("Table " + tableInfo.getName() + " exist status");
                    tableInfo.setIncludeStatus(true);
                }
                tableInfo.addColumn(field);
            });
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

