/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.builder.converts;

import cn.net.vidyo.framework.builder.converts.TypeConverts;
import cn.net.vidyo.framework.builder.domain.DateType;
import cn.net.vidyo.framework.builder.domain.DbColumnType;
import cn.net.vidyo.framework.builder.domain.IColumnType;
import cn.net.vidyo.framework.builder.domain.ITypeConvert;
import java.util.function.Function;

public class OscarTypeConvert
implements ITypeConvert {
    public static final OscarTypeConvert INSTANCE = new OscarTypeConvert();

    @Override
    public IColumnType processTypeConvert(DateType dateType, String fieldType) {
        return TypeConverts.use(fieldType).test(TypeConverts.containsAny("CHARACTER", "char", "varchar", "text", "character varying").then(DbColumnType.STRING)).test(TypeConverts.containsAny("bigint", "int8").then(DbColumnType.LONG)).test(TypeConverts.containsAny("int", "int1", "int2", "int3", "int4", "tinyint", "integer").then(DbColumnType.INTEGER)).test(TypeConverts.containsAny("date", "time", "timestamp").then((IColumnType)((Object)((Function<String, IColumnType>)p -> this.toDateType(dateType, (String)p))))).test(TypeConverts.containsAny("bit", "boolean").then(DbColumnType.BOOLEAN)).test(TypeConverts.containsAny("decimal", "numeric", "number").then(DbColumnType.BIG_DECIMAL)).test(TypeConverts.contains("clob").then(DbColumnType.CLOB)).test(TypeConverts.contains("blob").then(DbColumnType.BYTE_ARRAY)).test(TypeConverts.contains("float").then(DbColumnType.FLOAT)).test(TypeConverts.containsAny("double", "real", "float4", "float8").then(DbColumnType.DOUBLE)).or(DbColumnType.STRING);
    }

    private IColumnType toDateType(DateType dateType, String type) {
        if (dateType == DateType.SQL_PACK) {
            switch (type) {
                case "date": {
                    return DbColumnType.DATE_SQL;
                }
                case "time": {
                    return DbColumnType.TIME;
                }
            }
            return DbColumnType.TIMESTAMP;
        }
        if (dateType == DateType.TIME_PACK) {
            switch (type) {
                case "date": {
                    return DbColumnType.LOCAL_DATE;
                }
                case "time": {
                    return DbColumnType.LOCAL_TIME;
                }
            }
            return DbColumnType.LOCAL_DATE_TIME;
        }
        return DbColumnType.DATE;
    }
}

