/*
 * Decompiled with CFR 0.152.
 */
package cn.net.vidyo.framework.builder.config;

import cn.net.vidyo.framework.builder.config.Module;
import cn.net.vidyo.framework.builder.config.ProjectItem;
import cn.net.vidyo.framework.builder.domain.DateType;
import cn.net.vidyo.framework.builder.template.ITemplate;
import cn.net.vidyo.framework.builder.template.Template;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.Assert;

public class Project
extends ProjectItem {
    private DateType dateType = DateType.TIME_PACK;
    public static final String ROOT_MODULE_NAME = "root";
    Map<String, String> aliasMap = new HashMap<String, String>();
    public String defaultTemplatePath = "template/default/";
    public String templatePath = "";
    List<String> autoComponentFieldNames = new ArrayList<String>();
    List<String> businessComponentFieldNames = new ArrayList<String>();
    List<String> excludeComponentFieldNames = new ArrayList<String>();
    List<String> autoComponentConditionFieldNames = new ArrayList<String>();
    List<String> displayNameFieldNames = new ArrayList<String>();

    public boolean isDisplayNameField(String fieldName) {
        return this.displayNameFieldNames.contains(fieldName.toLowerCase());
    }

    public boolean isAutoComponentConditionField(String fieldName) {
        return this.autoComponentConditionFieldNames.contains(fieldName.toLowerCase());
    }

    public boolean isAutoComponentField(String fieldName) {
        return this.autoComponentFieldNames.contains(fieldName.toLowerCase());
    }

    public boolean isBusinessComponentField(String fieldName) {
        return this.businessComponentFieldNames.contains(fieldName.toLowerCase());
    }

    public boolean isExcludeComponentField(String fieldName) {
        return this.excludeComponentFieldNames.contains(fieldName.toLowerCase());
    }

    public Project addDisplayNameFieldNames(String ... names) {
        for (String name : names) {
            this.displayNameFieldNames.add(name.toLowerCase());
        }
        return this;
    }

    public Project addAutoComponentFieldNames(String ... names) {
        for (String name : names) {
            this.autoComponentFieldNames.add(name.toLowerCase());
        }
        return this;
    }

    public Project addAutoComponentConditionFieldNames(String ... names) {
        for (String name : names) {
            this.autoComponentConditionFieldNames.add(name.toLowerCase());
        }
        return this;
    }

    public Project addExclueComponentFieldNames(String ... names) {
        for (String name : names) {
            this.excludeComponentFieldNames.add(name.toLowerCase());
        }
        return this;
    }

    public Project addBusinessComponentFieldNames(String ... names) {
        for (String name : names) {
            this.businessComponentFieldNames.add(name.toLowerCase());
        }
        return this;
    }

    public String getAlias(String key) {
        if (this.aliasMap.containsKey(key)) {
            return this.aliasMap.get(key);
        }
        return "";
    }

    public Project addAlias(String ... nameAliass) {
        for (int index = 0; index < nameAliass.length; ++index) {
            String key = nameAliass[index];
            String alias = nameAliass[index + 1];
            this.aliasMap.put(key, alias);
            ++index;
        }
        return this;
    }

    public Module addRootModule() {
        Module module = new Module();
        module.setName(ROOT_MODULE_NAME);
        module.setComment(ROOT_MODULE_NAME);
        module.setOutpath("");
        module.setNamespace("");
        module.setOverrideModel(this.overrideModel);
        this.addModule(module);
        return module;
    }

    public Module getRootModule() {
        return this.getModule(ROOT_MODULE_NAME);
    }

    public Project addDefaultTemplate() {
        Module rootModule = this.getRootModule();
        if (rootModule == null) {
            rootModule = this.addRootModule();
        }
        this.addModuleTemplate(rootModule.getName(), this.getDefaultEntityTemplate(), this.getDefaultDaoTemplate(), this.getDefaultMapperXmlTemplate(), this.getDefaultAutoServiceTemplate(), this.getDefaultAutoServiceImplTemplate(), this.getDefaultServiceTemplate(), this.getDefaultServiceImplTemplate(), this.getDefaultConditionTemplate(), this.getDefaultConverterTemplate(), this.getDefaultAutoControllerTemplate(), this.getDefaultUiApiTemplate());
        return this;
    }

    public Project addRootModuleTemplate(ITemplate ... templates) {
        return this.addModuleTemplate(ROOT_MODULE_NAME, templates);
    }

    public Project addModuleTemplate(String moduleName, ITemplate ... templates) {
        Module module = this.getModule(moduleName);
        Assert.notNull((Object)module, (String)("\u6ca1\u6709\u8fd9\u4e2a\u6a21\u5757" + moduleName));
        module.addTemplate(templates);
        return this;
    }

    public Template getDefaultEntityTemplate() {
        Template template = new Template();
        template.setTemplatePath("entity.java.ftl");
        template.setName("entity");
        template.setPath("/service/data/entity");
        template.setNamespace(".data.entity");
        template.setPrefix("");
        template.setPostfix(".java");
        return template;
    }

    public Template getDefaultDaoTemplate() {
        Template template = new Template();
        template.setTemplatePath("dao.java.ftl");
        template.setName("dao");
        template.setPath("/service/data/auto/dao");
        template.setNamespace(".data.auto.dao");
        template.setPrefix("");
        template.setPostfix("Dao.java");
        return template;
    }

    public Template getDefaultAutoServiceTemplate() {
        Template template = new Template();
        template.setTemplatePath("autoservice.java.ftl");
        template.setName("autoservice");
        template.setPath("/service/data/auto/service");
        template.setNamespace(".data.auto.service");
        template.setPrefix("");
        template.setPostfix("AutoService.java");
        return template;
    }

    public Template getDefaultAutoServiceImplTemplate() {
        Template template = new Template();
        template.setTemplatePath("autoserviceImpl.java.ftl");
        template.setName("autoserviceImpl");
        template.setPath("/service/data/auto/service/impl");
        template.setNamespace(".data.auto.service.impl");
        template.setPrefix("");
        template.setPostfix("AutoServiceImpl.java");
        return template;
    }

    public Template getDefaultAutoConditionTemplate() {
        Template template = new Template();
        template.setTemplatePath("autocondition.java.ftl");
        template.setName("autocondition");
        template.setPath("/service/data/auto/condition");
        template.setNamespace(".data.auto.condition");
        template.setPrefix("");
        template.setPostfix("AutoCondition.java");
        return template;
    }

    public Template getDefaultServiceTemplate() {
        Template template = new Template();
        template.setTemplatePath("service.java.ftl");
        template.setName("service");
        template.setPath("/service/data/service");
        template.setNamespace(".data.service");
        template.setPrefix("");
        template.setPostfix("Service.java");
        return template;
    }

    public Template getDefaultServiceImplTemplate() {
        Template template = new Template();
        template.setTemplatePath("serviceImpl.java.ftl");
        template.setName("serviceImpl");
        template.setPath("/service/data/service/impl");
        template.setNamespace(".data.service.impl");
        template.setPrefix("");
        template.setPostfix("ServiceImpl.java");
        return template;
    }

    public Template getDefaultOneServiceTemplate() {
        Template template = new Template();
        template.setTemplatePath("oneservice.java.ftl");
        template.setName("oneservice");
        template.setPath("/service/data/service");
        template.setNamespace(".data.service");
        template.setPrefix("");
        template.setPostfix("Service.java");
        return template;
    }

    public Template getDefaultMapperXmlTemplate() {
        Template template = new Template();
        template.setTemplatePath("mapper.xml.ftl");
        template.setName("mapper");
        template.setPath("/service/resources/mapper");
        template.setPrefix("");
        template.setPostfix("Mapper.xml");
        return template;
    }

    public Template getDefaultConditionTemplate() {
        Template template = new Template();
        template.setTemplatePath("condition.java.ftl");
        template.setName("condition");
        template.setPath("/service/data/condition");
        template.setNamespace(".data.condition");
        template.setPrefix("");
        template.setPostfix("Condition.java");
        return template;
    }

    public Template getDefaultConverterTemplate() {
        Template template = new Template();
        template.setTemplatePath("converter.java.ftl");
        template.setName("converter");
        template.setPath("/service/data/converter");
        template.setNamespace(".data.converter");
        template.setPrefix("");
        template.setPostfix("Converter.java");
        return template;
    }

    public Template getDefaultAutoControllerTemplate() {
        Template template = new Template();
        template.setTemplatePath("autocontroller.java.ftl");
        template.setName("autocontroller");
        template.setPath("/api/web/auto");
        template.setNamespace(".web.auto");
        template.setPrefix("");
        template.setPostfix("AutoController.java");
        return template;
    }

    public Template getDefaultUiApiTemplate() {
        Template template = new Template();
        template.setTemplatePath("web.ui.api.ts.ftl");
        template.setName("uiapi");
        template.setPath("/ui/src/api/auto");
        template.setNamespace(".web.ui.auto");
        template.setPrefix("");
        template.setPostfix(".ts");
        return template;
    }

    public Project addModule(Module ... modules) {
        for (Module module : modules) {
            if (module.getNamespace().length() > 0) {
                module.setFullNamespace(this.namespace + "." + module.getNamespace());
            } else {
                module.setFullNamespace(this.namespace);
            }
            if (module.getOutpath().length() > 0) {
                module.setFullOutpath(this.getOutpath() + File.separator + module.getOutpath());
                continue;
            }
            module.setFullOutpath(this.getOutpath());
        }
        this.addItem(modules);
        return this;
    }

    public Module getModule(String name) {
        ProjectItem item = this.getItem(name);
        return (Module)item;
    }

    public Module getModuleByTableName(String tableName) {
        for (ProjectItem item : this.items) {
            Module module = (Module)item;
            if (!module.containsByTableName(this.name)) continue;
            return module;
        }
        return null;
    }

    public Project addTableName(String moduleName, String ... tableNames) {
        Module module = this.getModule(moduleName);
        if (module == null) {
            module = new Module();
            module.setName(moduleName);
            module.setComment(moduleName);
            module.setOutpath(moduleName);
            module.setNamespace(moduleName);
            module.setOverrideModel(this.overrideModel);
            this.addItem(module);
        }
        module.addTableName(tableNames);
        return this;
    }

    public List<String> getAutoComponentConditionFieldNames() {
        return this.autoComponentConditionFieldNames;
    }

    public void setAutoComponentConditionFieldNames(List<String> autoComponentConditionFieldNames) {
        this.autoComponentConditionFieldNames = autoComponentConditionFieldNames;
    }

    public List<String> getDisplayNameFieldNames() {
        return this.displayNameFieldNames;
    }

    public void setDisplayNameFieldNames(List<String> displayNameFieldNames) {
        this.displayNameFieldNames = displayNameFieldNames;
    }

    public List<String> getAutoComponentFieldNames() {
        return this.autoComponentFieldNames;
    }

    public void setAutoComponentFieldNames(List<String> autoComponentFieldNames) {
        this.autoComponentFieldNames = autoComponentFieldNames;
    }

    public List<String> getBusinessComponentFieldNames() {
        return this.businessComponentFieldNames;
    }

    public void setBusinessComponentFieldNames(List<String> businessComponentFieldNames) {
        this.businessComponentFieldNames = businessComponentFieldNames;
    }

    public List<String> getExcludeComponentFieldNames() {
        return this.excludeComponentFieldNames;
    }

    public void setExcludeComponentFieldNames(List<String> excludeComponentFieldNames) {
        this.excludeComponentFieldNames = excludeComponentFieldNames;
    }

    public String getDefaultTemplatePath() {
        return this.defaultTemplatePath;
    }

    public void setDefaultTemplatePath(String defaultTemplatePath) {
        this.defaultTemplatePath = defaultTemplatePath;
    }

    public String getTemplatePath() {
        return this.templatePath;
    }

    public void setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
    }

    public DateType getDateType() {
        return this.dateType;
    }

    public void setDateType(DateType dateType) {
        this.dateType = dateType;
    }
}

